/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth2;

public enum OAuth2Error {
    INVALID_REQUEST("invalid_request"),
    UNAUTHORIZED_CLIENT("unauthorized_client"),
    ACCESS_DENIED("access_denied"),
    UNSUPPORTED_RESPONSE_TYPE("unsupported_response_type"),
    INVALID_SCOPE("invalid_scope"),
    SERVER_ERROR("server_error"),
    TEMPORARILY_UNAVAILABLE("temporarily_unavailable"),
    INVALID_CLIENT("invalid_client"),
    INVALID_GRANT("invalid_grant"),
    UNSUPPORTED_GRANT_TYPE("unsupported_grant_type"),
    INVALID_TOKEN("invalid_token"),
    INSUFFICIENT_SCOPE("insufficient_scope"),
    UNSUPPORTED_TOKEN_TYPE("unsupported_token_type");

    private final String errorString;

    private OAuth2Error(String errorString) {
        this.errorString = errorString;
    }

    public static OAuth2Error parseFrom(String errorString) {
        for (OAuth2Error error : OAuth2Error.values()) {
            if (!error.errorString.equals(errorString)) continue;
            return error;
        }
        throw new IllegalArgumentException("there is no knowlege about '" + errorString + "' Error");
    }

    public String getErrorString() {
        return this.errorString;
    }
}

