/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import io.airlift.discovery.client.CachingServiceSelector;
import io.airlift.discovery.client.DiscoveryLookupClient;
import io.airlift.discovery.client.ForDiscoveryClient;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceSelectorConfig;
import io.airlift.discovery.client.ServiceSelectorFactory;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;

public class CachingServiceSelectorFactory
implements ServiceSelectorFactory {
    private final DiscoveryLookupClient lookupClient;
    private final ScheduledExecutorService executor;

    @Inject
    public CachingServiceSelectorFactory(DiscoveryLookupClient lookupClient, @ForDiscoveryClient ScheduledExecutorService executor) {
        Objects.requireNonNull(lookupClient, "client is null");
        Objects.requireNonNull(executor, "executor is null");
        this.lookupClient = lookupClient;
        this.executor = executor;
    }

    @Override
    public ServiceSelector createServiceSelector(String type, ServiceSelectorConfig selectorConfig) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(selectorConfig, "selectorConfig is null");
        CachingServiceSelector serviceSelector = new CachingServiceSelector(type, selectorConfig, this.lookupClient, this.executor);
        serviceSelector.start();
        return serviceSelector;
    }
}

