/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.cli.PulsarClientTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(commandDescription="Generate documentation automatically.")
public class CmdGenerateDocumentation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CmdGenerateDocumentation.class);
    @Parameter(names={"-n", "--command-names"}, description="List of command names")
    private List<String> commandNames = new ArrayList<String>();

    public int run() throws PulsarClientException {
        PulsarClientTool pulsarClientTool = new PulsarClientTool(new Properties());
        JCommander commander = pulsarClientTool.jcommander;
        if (this.commandNames.size() == 0) {
            for (Map.Entry cmd : commander.getCommands().entrySet()) {
                if (((String)cmd.getKey()).equals("generate_documentation")) continue;
                this.generateDocument((String)cmd.getKey(), commander);
            }
        } else {
            for (String commandName : this.commandNames) {
                if (commandName.equals("generate_documentation")) continue;
                this.generateDocument(commandName, commander);
            }
        }
        return 0;
    }

    protected String generateDocument(String module, JCommander parentCmd) {
        StringBuilder sb = new StringBuilder();
        JCommander cmd = (JCommander)parentCmd.getCommands().get(module);
        sb.append("## ").append(module).append("\n\n");
        sb.append(parentCmd.getUsageFormatter().getCommandDescription(module)).append("\n");
        sb.append("\n\n```shell\n").append("$ pulsar-client ").append(module).append(" [options]").append("\n```");
        sb.append("\n\n");
        sb.append("|Flag|Description|Default|\n");
        sb.append("|---|---|---|\n");
        List options = cmd.getParameters();
        options.stream().filter(ele -> !ele.getParameterAnnotation().hidden()).forEach(option -> sb.append("| `").append(option.getNames()).append("` | ").append(option.getDescription().replace("\n", " ")).append("|").append(option.getDefault()).append("|\n"));
        System.out.println(sb.toString());
        return sb.toString();
    }

    @Generated
    public List<String> getCommandNames() {
        return this.commandNames;
    }
}

