/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.server;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.discovery.server.DiscoveryServerModule;
import io.airlift.event.client.http.HttpEventModule;
import io.airlift.http.server.HttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.JmxModule;
import io.airlift.jmx.http.rpc.JmxHttpRpcModule;
import io.airlift.json.JsonModule;
import io.airlift.log.Logger;
import io.airlift.node.NodeModule;
import io.airlift.tracetoken.TraceTokenModule;
import org.weakref.jmx.guice.MBeanModule;

public final class DiscoveryServer {
    private static final Logger log = Logger.get(DiscoveryServer.class);

    private DiscoveryServer() {
    }

    public static void main(String[] args) {
        try {
            Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new NodeModule(), new HttpServerModule(), new JaxrsModule(), new JsonModule(), new JmxModule(), new JmxHttpRpcModule(), new DiscoveryServerModule(), new HttpEventModule(), new TraceTokenModule(), new DiscoveryModule()});
            Injector injector = app.strictConfig().initialize();
            ((Announcer)injector.getInstance(Announcer.class)).start();
        }
        catch (Throwable t) {
            log.error(t);
            System.exit(1);
        }
    }
}

