/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Rescorer;
import org.apache.lucene.search.ScoreAndDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;

public class SortRescorer
extends Rescorer {
    private final Sort sort;

    public SortRescorer(Sort sort) {
        this.sort = sort;
    }

    @Override
    public TopDocs rescore(IndexSearcher searcher, TopDocs firstPassTopDocs, int topN) throws IOException {
        ScoreDoc[] hits = (ScoreDoc[])firstPassTopDocs.scoreDocs.clone();
        Comparator<ScoreDoc> docIdComparator = Comparator.comparingInt(sd -> sd.doc);
        Arrays.sort(hits, docIdComparator);
        List<LeafReaderContext> leaves = searcher.getIndexReader().leaves();
        TopFieldCollector collector = TopFieldCollector.create(this.sort, topN, Integer.MAX_VALUE);
        int readerUpto = -1;
        int endDoc = 0;
        int docBase = 0;
        LeafCollector leafCollector = null;
        ScoreAndDoc scoreAndDoc = new ScoreAndDoc();
        for (int hitUpto = 0; hitUpto < hits.length; ++hitUpto) {
            ScoreDoc hit = hits[hitUpto];
            int docID = hit.doc;
            LeafReaderContext readerContext = null;
            while (docID >= endDoc) {
                readerContext = leaves.get(++readerUpto);
                endDoc = readerContext.docBase + readerContext.reader().maxDoc();
            }
            if (readerContext != null) {
                leafCollector = collector.getLeafCollector(readerContext);
                leafCollector.setScorer(scoreAndDoc);
                docBase = readerContext.docBase;
            }
            scoreAndDoc.score = hit.score;
            scoreAndDoc.doc = docID - docBase;
            leafCollector.collect(scoreAndDoc.doc);
        }
        TopFieldDocs rescoredDocs = collector.topDocs();
        assert (hits.length == rescoredDocs.scoreDocs.length);
        ScoreDoc[] rescoredDocsClone = (ScoreDoc[])rescoredDocs.scoreDocs.clone();
        Arrays.sort(rescoredDocsClone, docIdComparator);
        for (int i = 0; i < rescoredDocsClone.length; ++i) {
            rescoredDocsClone[i].score = hits[i].score;
        }
        return rescoredDocs;
    }

    @Override
    public Explanation explain(IndexSearcher searcher, Explanation firstPassExplanation, int docID) throws IOException {
        TopDocs oneHit = new TopDocs(new TotalHits(1L, TotalHits.Relation.EQUAL_TO), new ScoreDoc[]{new ScoreDoc(docID, firstPassExplanation.getValue().floatValue())});
        TopDocs hits = this.rescore(searcher, oneHit, 1);
        assert (hits.totalHits.value == 1L);
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        Explanation first = Explanation.match(firstPassExplanation.getValue(), "first pass score", firstPassExplanation);
        subs.add(first);
        FieldDoc fieldDoc = (FieldDoc)hits.scoreDocs[0];
        SortField[] sortFields = this.sort.getSort();
        for (int i = 0; i < sortFields.length; ++i) {
            subs.add(Explanation.match((Number)Float.valueOf(0.0f), "sort field " + sortFields[i].toString() + " value=" + fieldDoc.fields[i], new Explanation[0]));
        }
        return Explanation.match((Number)Float.valueOf(0.0f), "sort field values for sort=" + this.sort.toString(), subs);
    }
}

