/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.Arrays;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;

public abstract class RunAutomaton
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(RunAutomaton.class);
    final Automaton automaton;
    final int alphabetSize;
    final int size;
    final boolean[] accept;
    final int[] transitions;
    final int[] points;
    final int[] classmap;

    protected RunAutomaton(Automaton a, int alphabetSize) {
        this(a, alphabetSize, 10000);
    }

    protected RunAutomaton(Automaton a, int alphabetSize, int maxDeterminizedStates) {
        this.alphabetSize = alphabetSize;
        this.automaton = a = Operations.determinize(a, maxDeterminizedStates);
        this.points = a.getStartPoints();
        this.size = Math.max(1, a.getNumStates());
        this.accept = new boolean[this.size];
        this.transitions = new int[this.size * this.points.length];
        Arrays.fill(this.transitions, -1);
        for (int n = 0; n < this.size; ++n) {
            this.accept[n] = a.isAccept(n);
            for (int c = 0; c < this.points.length; ++c) {
                int dest = a.step(n, this.points[c]);
                assert (dest == -1 || dest < this.size);
                this.transitions[n * this.points.length + c] = dest;
            }
        }
        this.classmap = new int[Math.min(256, alphabetSize)];
        int i = 0;
        for (int j = 0; j < this.classmap.length; ++j) {
            if (i + 1 >= this.points.length || j == this.points[i + 1]) {
                // empty if block
            }
            this.classmap[j] = ++i;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("initial state: 0\n");
        for (int i = 0; i < this.size; ++i) {
            b.append("state ").append(i);
            if (this.accept[i]) {
                b.append(" [accept]:\n");
            } else {
                b.append(" [reject]:\n");
            }
            for (int j = 0; j < this.points.length; ++j) {
                int k = this.transitions[i * this.points.length + j];
                if (k == -1) continue;
                int min = this.points[j];
                int max = j + 1 < this.points.length ? this.points[j + 1] - 1 : this.alphabetSize;
                b.append(" ");
                Automaton.appendCharString(min, b);
                if (min != max) {
                    b.append("-");
                    Automaton.appendCharString(max, b);
                }
                b.append(" -> ").append(k).append("\n");
            }
        }
        return b.toString();
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean isAccept(int state) {
        return this.accept[state];
    }

    public final int[] getCharIntervals() {
        return (int[])this.points.clone();
    }

    final int getCharClass(int c) {
        int a = 0;
        int b = this.points.length;
        while (b - a > 1) {
            int d = a + b >>> 1;
            if (this.points[d] > c) {
                b = d;
                continue;
            }
            if (this.points[d] < c) {
                a = d;
                continue;
            }
            return d;
        }
        return a;
    }

    public final int step(int state, int c) {
        assert (c < this.alphabetSize);
        if (c >= this.classmap.length) {
            return this.transitions[state * this.points.length + this.getCharClass(c)];
        }
        return this.transitions[state * this.points.length + this.classmap[c]];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.alphabetSize;
        result = 31 * result + this.points.length;
        result = 31 * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunAutomaton other = (RunAutomaton)obj;
        if (this.alphabetSize != other.alphabetSize) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (!Arrays.equals(this.points, other.points)) {
            return false;
        }
        if (!Arrays.equals(this.accept, other.accept)) {
            return false;
        }
        return Arrays.equals(this.transitions, other.transitions);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.accept) + RamUsageEstimator.sizeOfObject(this.automaton) + RamUsageEstimator.sizeOfObject(this.classmap) + RamUsageEstimator.sizeOfObject(this.points) + RamUsageEstimator.sizeOfObject(this.transitions);
    }
}

