/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public final class ResourceEstimates {
    public static final String EXECUTION_TIME = "EXECUTION_TIME";
    public static final String CPU_TIME = "CPU_TIME";
    public static final String PEAK_MEMORY = "PEAK_MEMORY";
    private final Optional<Duration> executionTime;
    private final Optional<Duration> cpuTime;
    private final Optional<Long> peakMemoryBytes;

    @JsonCreator
    public ResourceEstimates(@JsonProperty(value="executionTime") Optional<Duration> executionTime, @JsonProperty(value="cpuTime") Optional<Duration> cpuTime, @JsonProperty(value="peakMemoryBytes") Optional<Long> peakMemoryBytes) {
        this.executionTime = Objects.requireNonNull(executionTime, "executionTime is null");
        this.cpuTime = Objects.requireNonNull(cpuTime, "cpuTime is null");
        this.peakMemoryBytes = Objects.requireNonNull(peakMemoryBytes, "peakMemoryBytes is null");
    }

    @JsonProperty
    public Optional<Duration> getExecutionTime() {
        return this.executionTime;
    }

    @JsonProperty
    public Optional<Duration> getCpuTime() {
        return this.cpuTime;
    }

    @JsonProperty
    public Optional<Long> getPeakMemoryBytes() {
        return this.peakMemoryBytes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResourceEstimates{");
        sb.append("executionTime=").append(this.executionTime);
        sb.append(", cpuTime=").append(this.cpuTime);
        sb.append(", peakMemoryBytes=").append(this.peakMemoryBytes);
        sb.append('}');
        return sb.toString();
    }
}

