/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.api.kv.impl.options;

import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import org.apache.bookkeeper.api.kv.impl.options.RangeOptionBuilderImpl;
import org.apache.bookkeeper.api.kv.options.RangeOption;

class RangeOptionImpl<K>
implements RangeOption<K> {
    private final Recycler.Handle<RangeOptionImpl<K>> handle;
    private long limit;
    private long minModRev = Long.MIN_VALUE;
    private long maxModRev = Long.MAX_VALUE;
    private long minCreateRev = Long.MIN_VALUE;
    private long maxCreateRev = Long.MAX_VALUE;
    private boolean keysOnly;
    private boolean countOnly;
    private K endKey;

    static <K> RangeOptionImpl<K> create(Recycler<RangeOptionImpl<K>> recycler) {
        return (RangeOptionImpl)recycler.get();
    }

    RangeOptionImpl(Recycler.Handle<RangeOptionImpl<K>> handle) {
        this.handle = handle;
    }

    void set(RangeOptionBuilderImpl<K> builderImpl) {
        this.limit = builderImpl.limit();
        this.minCreateRev = builderImpl.minCreateRev();
        this.maxCreateRev = builderImpl.maxCreateRev();
        this.minModRev = builderImpl.minModRev();
        this.maxModRev = builderImpl.maxModRev();
        this.keysOnly = builderImpl.keysOnly();
        this.countOnly = builderImpl.countOnly();
        ReferenceCountUtil.release(this.endKey);
        this.endKey = ReferenceCountUtil.retain(builderImpl.endKey());
    }

    @Override
    public void close() {
        this.limit = -1L;
        this.minModRev = Long.MIN_VALUE;
        this.maxModRev = Long.MAX_VALUE;
        this.minCreateRev = Long.MIN_VALUE;
        this.maxCreateRev = Long.MAX_VALUE;
        this.keysOnly = false;
        this.countOnly = false;
        ReferenceCountUtil.release(this.endKey);
        this.endKey = null;
        this.handle.recycle((Object)this);
    }

    public Recycler.Handle<RangeOptionImpl<K>> handle() {
        return this.handle;
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public long minModRev() {
        return this.minModRev;
    }

    @Override
    public long maxModRev() {
        return this.maxModRev;
    }

    @Override
    public long minCreateRev() {
        return this.minCreateRev;
    }

    @Override
    public long maxCreateRev() {
        return this.maxCreateRev;
    }

    @Override
    public boolean keysOnly() {
        return this.keysOnly;
    }

    @Override
    public boolean countOnly() {
        return this.countOnly;
    }

    @Override
    public K endKey() {
        return this.endKey;
    }

    public String toString() {
        return "RangeOptionImpl(limit=" + this.limit() + ", minModRev=" + this.minModRev() + ", maxModRev=" + this.maxModRev() + ", minCreateRev=" + this.minCreateRev() + ", maxCreateRev=" + this.maxCreateRev() + ", keysOnly=" + this.keysOnly() + ", countOnly=" + this.countOnly() + ", endKey=" + this.endKey() + ")";
    }
}

