/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.Beta;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataCacheConfig;
import org.apache.pulsar.metadata.api.MetadataSerde;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public interface MetadataStore
extends AutoCloseable {
    public static final Logger LOGGER = LoggerFactory.getLogger(MetadataStore.class);

    public CompletableFuture<Optional<GetResult>> get(String var1);

    default public CompletableFuture<Void> sync(String path) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<String>> getChildren(String var1);

    public CompletableFuture<List<String>> getChildrenFromStore(String var1);

    public CompletableFuture<Boolean> exists(String var1);

    public CompletableFuture<Stat> put(String var1, byte[] var2, Optional<Long> var3);

    public CompletableFuture<Void> delete(String var1, Optional<Long> var2);

    default public CompletableFuture<Void> deleteIfExists(String path, Optional<Long> expectedVersion) {
        return this.delete(path, expectedVersion).exceptionally(e -> {
            if (e.getCause() instanceof MetadataStoreException.NotFoundException) {
                LOGGER.info("Path {} not found while deleting (this is not a problem)", (Object)path);
                return null;
            }
            if (expectedVersion.isEmpty()) {
                LOGGER.info("Failed to delete path {}", (Object)path, e);
            } else {
                LOGGER.info("Failed to delete path {} with expected version {}", new Object[]{path, expectedVersion, e});
            }
            throw new CompletionException((Throwable)e);
        });
    }

    public CompletableFuture<Void> deleteRecursive(String var1);

    public void registerListener(Consumer<Notification> var1);

    public <T> MetadataCache<T> getMetadataCache(Class<T> var1, MetadataCacheConfig var2);

    default public <T> MetadataCache<T> getMetadataCache(Class<T> clazz) {
        return this.getMetadataCache(clazz, this.getDefaultMetadataCacheConfig());
    }

    public <T> MetadataCache<T> getMetadataCache(TypeReference<T> var1, MetadataCacheConfig var2);

    default public <T> MetadataCache<T> getMetadataCache(TypeReference<T> typeRef) {
        return this.getMetadataCache(typeRef, this.getDefaultMetadataCacheConfig());
    }

    public <T> MetadataCache<T> getMetadataCache(MetadataSerde<T> var1, MetadataCacheConfig var2);

    default public <T> MetadataCache<T> getMetadataCache(MetadataSerde<T> serde) {
        return this.getMetadataCache(serde, this.getDefaultMetadataCacheConfig());
    }

    default public MetadataCacheConfig getDefaultMetadataCacheConfig() {
        return MetadataCacheConfig.builder().build();
    }
}

