/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.common.naming.TopicBundleAssignmentStrategy;
import org.apache.pulsar.common.util.Reflections;

public class TopicBundleAssignmentFactory {
    public static final String DEFAULT_TOPIC_BUNDLE_ASSIGNMENT_STRATEGY = "org.apache.pulsar.common.naming.ConsistentHashingTopicBundleAssigner";
    private static volatile TopicBundleAssignmentStrategy strategy;

    public static TopicBundleAssignmentStrategy create(PulsarService pulsar) {
        if (strategy != null) {
            return strategy;
        }
        Class<TopicBundleAssignmentFactory> clazz = TopicBundleAssignmentFactory.class;
        synchronized (TopicBundleAssignmentFactory.class) {
            if (strategy != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return strategy;
            }
            String topicBundleAssignmentStrategy = TopicBundleAssignmentFactory.getTopicBundleAssignmentStrategy(pulsar);
            try {
                TopicBundleAssignmentStrategy tempStrategy = (TopicBundleAssignmentStrategy)Reflections.createInstance((String)topicBundleAssignmentStrategy, TopicBundleAssignmentStrategy.class, (ClassLoader)Thread.currentThread().getContextClassLoader());
                tempStrategy.init(pulsar);
                strategy = tempStrategy;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return strategy;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load TopicBundleAssignmentStrategy:" + topicBundleAssignmentStrategy, e);
            }
        }
    }

    private static String getTopicBundleAssignmentStrategy(PulsarService pulsar) {
        if (pulsar == null || pulsar.getConfiguration() == null) {
            return DEFAULT_TOPIC_BUNDLE_ASSIGNMENT_STRATEGY;
        }
        return pulsar.getConfiguration().getTopicBundleAssignmentStrategy();
    }
}

