/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.grpc;

import io.grpc.internal.BackoffPolicy;
import io.streamnative.oxia.client.util.Backoff;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OxiaBackoffProvider
implements BackoffPolicy.Provider {
    public static final BackoffPolicy.Provider DEFAULT = new OxiaBackoffProvider(100L, TimeUnit.MILLISECONDS, 60L, TimeUnit.MILLISECONDS);
    private final long initialDelay;
    private final TimeUnit unitInitialDelay;
    private final long maxDelay;
    private final TimeUnit unitMaxDelay;

    OxiaBackoffProvider(long initialDelay, TimeUnit unitInitialDelay, long maxDelay, TimeUnit unitMaxDelay) {
        this.initialDelay = initialDelay;
        this.unitInitialDelay = unitInitialDelay;
        this.maxDelay = maxDelay;
        this.unitMaxDelay = unitMaxDelay;
    }

    public BackoffPolicy get() {
        return new Backoff(this.initialDelay, this.unitInitialDelay, this.maxDelay, this.unitMaxDelay);
    }

    public static BackoffPolicy.Provider create(Duration minDelay, Duration maxDelay) {
        return new OxiaBackoffProvider(minDelay.getNano(), TimeUnit.NANOSECONDS, maxDelay.getNano(), TimeUnit.NANOSECONDS);
    }
}

