/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.NonPersistentTopics;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations on non-persistent topics"}, hidden=true)
public class CmdNonPersistentTopics
extends CmdBase {
    private NonPersistentTopics nonPersistentTopics;

    public CmdNonPersistentTopics(Supplier<PulsarAdmin> admin) {
        super("non-persistent", admin);
        this.addCommand("create-partitioned-topic", new CreatePartitionedCmd());
        this.addCommand("lookup", new Lookup());
        this.addCommand("stats", new GetStats());
        this.addCommand("stats-internal", new GetInternalStats());
        this.addCommand("get-partitioned-topic-metadata", new GetPartitionedTopicMetadataCmd());
        this.addCommand("list", new GetList());
        this.addCommand("list-in-bundle", new GetListInBundle());
    }

    private NonPersistentTopics getNonPersistentTopics() {
        if (this.nonPersistentTopics == null) {
            this.nonPersistentTopics = this.getAdmin().nonPersistentTopics();
        }
        return this.nonPersistentTopics;
    }

    @CommandLine.Command(description={"Create a partitioned topic. The partitioned topic has to be created before creating a producer on it."})
    private class CreatePartitionedCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"non-persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-p", "--partitions"}, description={"Number of partitions for the topic"}, required=true)
        private int numPartitions;

        private CreatePartitionedCmd() {
        }

        @Override
        void run() throws Exception {
            String persistentTopic = CreatePartitionedCmd.validateNonPersistentTopic(this.topicName);
            CmdNonPersistentTopics.this.getNonPersistentTopics().createPartitionedTopic(persistentTopic, this.numPartitions);
        }
    }

    @CommandLine.Command(description={"Lookup a topic from the current serving broker"})
    private class Lookup
    extends CliCommand {
        @CommandLine.Parameters(description={"non-persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private Lookup() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = Lookup.validateTopicName(this.topicName);
            this.print(CmdNonPersistentTopics.this.getAdmin().lookups().lookupTopic(topic));
        }
    }

    @CommandLine.Command(description={"Get the stats for the topic and its connected producers and consumers. All the rates are computed over a 1 minute window and are relative the last completed 1 minute period."})
    private class GetStats
    extends CliCommand {
        @CommandLine.Parameters(description={"non-persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetStats() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetStats.validateNonPersistentTopic(this.topicName);
            this.print(CmdNonPersistentTopics.this.getNonPersistentTopics().getStats(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Get the internal stats for the topic"})
    private class GetInternalStats
    extends CliCommand {
        @CommandLine.Parameters(description={"non-persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetInternalStats() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetInternalStats.validateNonPersistentTopic(this.topicName);
            this.print(CmdNonPersistentTopics.this.getNonPersistentTopics().getInternalStats(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Get the partitioned topic metadata. If the topic is not created or is a non-partitioned topic, it returns empty topic with 0 partitions"})
    private class GetPartitionedTopicMetadataCmd
    extends CliCommand {
        @CommandLine.Parameters(description={"non-persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private GetPartitionedTopicMetadataCmd() {
        }

        @Override
        void run() throws Exception {
            String nonPersistentTopic = GetPartitionedTopicMetadataCmd.validateNonPersistentTopic(this.topicName);
            this.print(CmdNonPersistentTopics.this.getNonPersistentTopics().getPartitionedTopicMetadata(nonPersistentTopic));
        }
    }

    @CommandLine.Command(description={"Get list of non-persistent topics present under a namespace"})
    private class GetList
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespace;

        private GetList() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdNonPersistentTopics.this.getNonPersistentTopics().getList(this.namespace));
        }
    }

    @CommandLine.Command(description={"Get list of non-persistent topics present under a namespace bundle"})
    private class GetListInBundle
    extends CliCommand {
        @CommandLine.Parameters(description={"tenant/namespace"}, arity="1")
        private String namespace;
        @CommandLine.Option(names={"-b", "--bundle"}, description={"bundle range"}, required=true)
        private String bundleRange;

        private GetListInBundle() {
        }

        @Override
        void run() throws PulsarAdminException {
            this.print(CmdNonPersistentTopics.this.getNonPersistentTopics().getListInBundle(this.namespace, this.bundleRange));
        }
    }
}

