/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableWindowSubscribeIntercept;
import io.reactivex.rxjava3.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableWindow<T>
extends AbstractFlowableWithUpstream<T, Flowable<T>> {
    final long size;
    final long skip;
    final int bufferSize;

    public FlowableWindow(Flowable<T> source, long size, long skip, int bufferSize) {
        super(source);
        this.size = size;
        this.skip = skip;
        this.bufferSize = bufferSize;
    }

    @Override
    public void subscribeActual(Subscriber<? super Flowable<T>> s) {
        if (this.skip == this.size) {
            this.source.subscribe(new WindowExactSubscriber(s, this.size, this.bufferSize));
        } else if (this.skip > this.size) {
            this.source.subscribe(new WindowSkipSubscriber(s, this.size, this.skip, this.bufferSize));
        } else {
            this.source.subscribe(new WindowOverlapSubscriber(s, this.size, this.skip, this.bufferSize));
        }
    }

    static final class WindowOverlapSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 2428527070996323976L;
        final Subscriber<? super Flowable<T>> downstream;
        final SpscLinkedArrayQueue<UnicastProcessor<T>> queue;
        final long size;
        final long skip;
        final ArrayDeque<UnicastProcessor<T>> windows;
        final AtomicBoolean once;
        final AtomicBoolean firstRequest;
        final AtomicLong requested;
        final AtomicInteger wip;
        final int bufferSize;
        long index;
        long produced;
        Subscription upstream;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;

        WindowOverlapSubscriber(Subscriber<? super Flowable<T>> actual, long size, long skip, int bufferSize) {
            super(1);
            this.downstream = actual;
            this.size = size;
            this.skip = skip;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.windows = new ArrayDeque();
            this.once = new AtomicBoolean();
            this.firstRequest = new AtomicBoolean();
            this.requested = new AtomicLong();
            this.wip = new AtomicInteger();
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            long p;
            long i = this.index;
            UnicastProcessor newWindow = null;
            if (i == 0L && !this.cancelled) {
                this.getAndIncrement();
                newWindow = UnicastProcessor.create(this.bufferSize, this);
                this.windows.offer(newWindow);
            }
            ++i;
            for (Processor processor : this.windows) {
                processor.onNext(t);
            }
            if (newWindow != null) {
                this.queue.offer(newWindow);
                this.drain();
            }
            if ((p = this.produced + 1L) == this.size) {
                this.produced = p - this.skip;
                Processor w = this.windows.poll();
                if (w != null) {
                    w.onComplete();
                }
            } else {
                this.produced = p;
            }
            this.index = i == this.skip ? 0L : i;
        }

        public void onError(Throwable t) {
            for (Processor processor : this.windows) {
                processor.onError(t);
            }
            this.windows.clear();
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            for (Processor processor : this.windows) {
                processor.onComplete();
            }
            this.windows.clear();
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            Subscriber<? super Flowable<T>> a = this.downstream;
            SpscLinkedArrayQueue<UnicastProcessor<T>> q = this.queue;
            int missed = 1;
            block0: while (true) {
                if (this.cancelled) {
                    UnicastProcessor<T> up = null;
                    while ((up = q.poll()) != null) {
                        up.onComplete();
                    }
                } else {
                    long e;
                    long r = this.requested.get();
                    for (e = 0L; e != r; ++e) {
                        boolean empty;
                        boolean d = this.done;
                        UnicastProcessor<T> t = q.poll();
                        boolean bl = empty = t == null;
                        if (this.cancelled) continue block0;
                        if (this.checkTerminated(d, empty, a, q)) {
                            return;
                        }
                        if (empty) break;
                        FlowableWindowSubscribeIntercept<T> intercept = new FlowableWindowSubscribeIntercept<T>(t);
                        a.onNext(intercept);
                        if (!intercept.tryAbandon()) continue;
                        t.onComplete();
                    }
                    if (e == r) {
                        if (this.cancelled) continue;
                        if (this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                            return;
                        }
                    }
                    if (e != 0L && r != Long.MAX_VALUE) {
                        this.requested.addAndGet(-e);
                    }
                }
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a, SpscLinkedArrayQueue<?> q) {
            if (d) {
                Throwable e = this.error;
                if (e != null) {
                    q.clear();
                    a.onError(e);
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                if (!this.firstRequest.get() && this.firstRequest.compareAndSet(false, true)) {
                    long u = BackpressureHelper.multiplyCap(this.skip, n - 1L);
                    long v = BackpressureHelper.addCap(this.size, u);
                    this.upstream.request(v);
                } else {
                    long u = BackpressureHelper.multiplyCap(this.skip, n);
                    this.upstream.request(u);
                }
                this.drain();
            }
        }

        public void cancel() {
            this.cancelled = true;
            if (this.once.compareAndSet(false, true)) {
                this.run();
            }
            this.drain();
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }
    }

    static final class WindowSkipSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -8792836352386833856L;
        final Subscriber<? super Flowable<T>> downstream;
        final long size;
        final long skip;
        final AtomicBoolean once;
        final AtomicBoolean firstRequest;
        final int bufferSize;
        long index;
        Subscription upstream;
        UnicastProcessor<T> window;

        WindowSkipSubscriber(Subscriber<? super Flowable<T>> actual, long size, long skip, int bufferSize) {
            super(1);
            this.downstream = actual;
            this.size = size;
            this.skip = skip;
            this.once = new AtomicBoolean();
            this.firstRequest = new AtomicBoolean();
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            long i = this.index;
            FlowableWindowSubscribeIntercept<T> intercept = null;
            UnicastProcessor<T> w = this.window;
            if (i == 0L) {
                this.getAndIncrement();
                w = UnicastProcessor.create(this.bufferSize, this);
                this.window = w;
                intercept = new FlowableWindowSubscribeIntercept<T>(w);
                this.downstream.onNext(intercept);
            }
            ++i;
            if (w != null) {
                w.onNext(t);
            }
            if (i == this.size) {
                this.window = null;
                w.onComplete();
            }
            this.index = i == this.skip ? 0L : i;
            if (intercept != null && intercept.tryAbandon()) {
                intercept.window.onComplete();
            }
        }

        public void onError(Throwable t) {
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onError(t);
            }
            this.downstream.onError(t);
        }

        public void onComplete() {
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onComplete();
            }
            this.downstream.onComplete();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                if (!this.firstRequest.get() && this.firstRequest.compareAndSet(false, true)) {
                    long u = BackpressureHelper.multiplyCap(this.size, n);
                    long v = BackpressureHelper.multiplyCap(this.skip - this.size, n - 1L);
                    long w = BackpressureHelper.addCap(u, v);
                    this.upstream.request(w);
                } else {
                    long u = BackpressureHelper.multiplyCap(this.skip, n);
                    this.upstream.request(u);
                }
            }
        }

        public void cancel() {
            if (this.once.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }
    }

    static final class WindowExactSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -2365647875069161133L;
        final Subscriber<? super Flowable<T>> downstream;
        final long size;
        final AtomicBoolean once;
        final int bufferSize;
        long index;
        Subscription upstream;
        UnicastProcessor<T> window;

        WindowExactSubscriber(Subscriber<? super Flowable<T>> actual, long size, int bufferSize) {
            super(1);
            this.downstream = actual;
            this.size = size;
            this.once = new AtomicBoolean();
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            long i = this.index;
            UnicastProcessor<T> w = this.window;
            FlowableWindowSubscribeIntercept<T> intercept = null;
            if (i == 0L) {
                this.getAndIncrement();
                w = UnicastProcessor.create(this.bufferSize, this);
                this.window = w;
                intercept = new FlowableWindowSubscribeIntercept<T>(w);
                this.downstream.onNext(intercept);
            }
            w.onNext(t);
            if (++i == this.size) {
                this.index = 0L;
                this.window = null;
                w.onComplete();
            } else {
                this.index = i;
            }
            if (intercept != null && intercept.tryAbandon()) {
                intercept.window.onComplete();
            }
        }

        public void onError(Throwable t) {
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onError(t);
            }
            this.downstream.onError(t);
        }

        public void onComplete() {
            UnicastProcessor<T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onComplete();
            }
            this.downstream.onComplete();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                long u = BackpressureHelper.multiplyCap(this.size, n);
                this.upstream.request(u);
            }
        }

        public void cancel() {
            if (this.once.compareAndSet(false, true)) {
                this.run();
            }
        }

        @Override
        public void run() {
            if (this.decrementAndGet() == 0) {
                this.upstream.cancel();
            }
        }
    }
}

