/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.impl;

import org.apache.bookkeeper.client.BookKeeperClientStats;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;

@StatsDoc(name="bookkeeper_client", category="client", help="BookKeeper client stats")
public class BookKeeperClientStatsImpl
implements BookKeeperClientStats {
    private final StatsLogger stats;
    @StatsDoc(name="LEDGER_CREATE", help="operation stats of creating ledgers")
    private final OpStatsLogger createOpLogger;
    @StatsDoc(name="LEDGER_DELETE", help="operation stats of deleting ledgers")
    private final OpStatsLogger deleteOpLogger;
    @StatsDoc(name="LEDGER_OPEN", help="operation stats of opening ledgers")
    private final OpStatsLogger openOpLogger;
    @StatsDoc(name="LEDGER_RECOVER", help="operation stats of recovering ledgers")
    private final OpStatsLogger recoverOpLogger;
    @StatsDoc(name="READ_ENTRY", help="operation stats of reading entries requests")
    private final OpStatsLogger readOpLogger;
    @StatsDoc(name="READ_ENTRY_DM", help="the number of read entries hitting DigestMismatch errors")
    private final Counter readOpDmCounter;
    @StatsDoc(name="READ_LAST_CONFIRMED_AND_ENTRY", help="operation stats of read_last_confirmed_and_entry requests")
    private final OpStatsLogger readLacAndEntryOpLogger;
    @StatsDoc(name="READ_LAST_CONFIRMED_AND_ENTRY_RESPONSE", help="operation stats of read_last_confirmed_and_entry responses")
    private final OpStatsLogger readLacAndEntryRespLogger;
    @StatsDoc(name="ADD_ENTRY", help="operation stats of adding entries requests")
    private final OpStatsLogger addOpLogger;
    @StatsDoc(name="FORCE", help="operation stats of force requests")
    private final OpStatsLogger forceOpLogger;
    @StatsDoc(name="ADD_ENTRY_UR", help="the number of add entries under replication")
    private final Counter addOpUrCounter;
    @StatsDoc(name="WRITE_LAC", help="operation stats of write_lac requests")
    private final OpStatsLogger writeLacOpLogger;
    @StatsDoc(name="READ_LAC", help="operation stats of read_lac requests")
    private final OpStatsLogger readLacOpLogger;
    @StatsDoc(name="LEDGER_RECOVER_ADD_ENTRIES", help="the distribution of entries written in ledger recovery requests")
    private final OpStatsLogger recoverAddEntriesStats;
    @StatsDoc(name="LEDGER_RECOVER_READ_ENTRIES", help="the distribution of entries read in ledger recovery requests")
    private final OpStatsLogger recoverReadEntriesStats;
    @StatsDoc(name="NUM_ENSEMBLE_CHANGE", help="The number of ensemble changes")
    private final Counter ensembleChangeCounter;
    @StatsDoc(name="LAC_UPDATE_HITS", help="The number of successful lac updates on piggybacked responses")
    private final Counter lacUpdateHitsCounter;
    @StatsDoc(name="LAC_UPDATE_MISSES", help="The number of unsuccessful lac updates on piggybacked responses")
    private final Counter lacUpdateMissesCounter;
    @StatsDoc(name="CLIENT_CHANNEL_WRITE_WAIT", help=" The latency distribution of waiting time on channel being writable")
    private final OpStatsLogger clientChannelWriteWaitStats;
    @StatsDoc(name="SPECULATIVE_READ_COUNT", help="The number of speculative read requests")
    private final Counter speculativeReadCounter;
    @StatsDoc(name="WRITE_DELAYED_DUE_TO_NOT_ENOUGH_FAULT_DOMAINS_LATENCY", help="The delay in write completion because min number of fault domains was not reached")
    private final OpStatsLogger writeDelayedDueToNotEnoughFaultDomainsLatency;
    @StatsDoc(name="WRITE_DELAYED_DUE_TO_NOT_ENOUGH_FAULT_DOMAINS", help="The number of times write completion was delayed because min number of fault domains was not reached")
    private final Counter writeDelayedDueToNotEnoughFaultDomains;
    @StatsDoc(name="WRITE_TIME_OUT_DUE_TO_NOT_ENOUGH_FAULT_DOMAINS", help="The number of times write completion timed out because min number of fault domains was not reached")
    private final Counter writeTimedOutDueToNotEnoughFaultDomains;

    public BookKeeperClientStatsImpl(StatsLogger stats) {
        this.stats = stats;
        this.createOpLogger = stats.getOpStatsLogger("LEDGER_CREATE");
        this.deleteOpLogger = stats.getOpStatsLogger("LEDGER_DELETE");
        this.openOpLogger = stats.getOpStatsLogger("LEDGER_OPEN");
        this.recoverOpLogger = stats.getOpStatsLogger("LEDGER_RECOVER");
        this.readOpLogger = stats.getOpStatsLogger("READ_ENTRY");
        this.readOpDmCounter = stats.getCounter("READ_ENTRY_DM");
        this.readLacAndEntryOpLogger = stats.getOpStatsLogger("READ_LAST_CONFIRMED_AND_ENTRY");
        this.readLacAndEntryRespLogger = stats.getOpStatsLogger("READ_LAST_CONFIRMED_AND_ENTRY_RESPONSE");
        this.addOpLogger = stats.getOpStatsLogger("ADD_ENTRY");
        this.forceOpLogger = stats.getOpStatsLogger("FORCE");
        this.addOpUrCounter = stats.getCounter("ADD_ENTRY_UR");
        this.writeLacOpLogger = stats.getOpStatsLogger("WRITE_LAC");
        this.readLacOpLogger = stats.getOpStatsLogger("READ_LAC");
        this.recoverAddEntriesStats = stats.getOpStatsLogger("LEDGER_RECOVER_ADD_ENTRIES");
        this.recoverReadEntriesStats = stats.getOpStatsLogger("LEDGER_RECOVER_READ_ENTRIES");
        this.ensembleChangeCounter = stats.getCounter("NUM_ENSEMBLE_CHANGE");
        this.lacUpdateHitsCounter = stats.getCounter("LAC_UPDATE_HITS");
        this.lacUpdateMissesCounter = stats.getCounter("LAC_UPDATE_MISSES");
        this.clientChannelWriteWaitStats = stats.getOpStatsLogger("CLIENT_CHANNEL_WRITE_WAIT");
        this.speculativeReadCounter = stats.getCounter("SPECULATIVE_READ_COUNT");
        this.writeDelayedDueToNotEnoughFaultDomainsLatency = stats.getOpStatsLogger("WRITE_DELAYED_DUE_TO_NOT_ENOUGH_FAULT_DOMAINS_LATENCY");
        this.writeDelayedDueToNotEnoughFaultDomains = stats.getCounter("WRITE_DELAYED_DUE_TO_NOT_ENOUGH_FAULT_DOMAINS");
        this.writeTimedOutDueToNotEnoughFaultDomains = stats.getCounter("WRITE_TIME_OUT_DUE_TO_NOT_ENOUGH_FAULT_DOMAINS");
    }

    @Override
    public OpStatsLogger getCreateOpLogger() {
        return this.createOpLogger;
    }

    @Override
    public OpStatsLogger getOpenOpLogger() {
        return this.openOpLogger;
    }

    @Override
    public OpStatsLogger getDeleteOpLogger() {
        return this.deleteOpLogger;
    }

    @Override
    public OpStatsLogger getRecoverOpLogger() {
        return this.recoverOpLogger;
    }

    @Override
    public OpStatsLogger getReadOpLogger() {
        return this.readOpLogger;
    }

    @Override
    public OpStatsLogger getReadLacAndEntryOpLogger() {
        return this.readLacAndEntryOpLogger;
    }

    @Override
    public OpStatsLogger getReadLacAndEntryRespLogger() {
        return this.readLacAndEntryRespLogger;
    }

    @Override
    public OpStatsLogger getAddOpLogger() {
        return this.addOpLogger;
    }

    @Override
    public OpStatsLogger getForceOpLogger() {
        return this.forceOpLogger;
    }

    @Override
    public OpStatsLogger getWriteLacOpLogger() {
        return this.writeLacOpLogger;
    }

    @Override
    public OpStatsLogger getReadLacOpLogger() {
        return this.readLacOpLogger;
    }

    @Override
    public OpStatsLogger getRecoverAddCountLogger() {
        return this.recoverAddEntriesStats;
    }

    @Override
    public OpStatsLogger getRecoverReadCountLogger() {
        return this.recoverReadEntriesStats;
    }

    @Override
    public Counter getReadOpDmCounter() {
        return this.readOpDmCounter;
    }

    @Override
    public Counter getAddOpUrCounter() {
        return this.addOpUrCounter;
    }

    @Override
    public Counter getSpeculativeReadCounter() {
        return this.speculativeReadCounter;
    }

    @Override
    public Counter getEnsembleChangeCounter() {
        return this.ensembleChangeCounter;
    }

    @Override
    public Counter getLacUpdateHitsCounter() {
        return this.lacUpdateHitsCounter;
    }

    @Override
    public Counter getLacUpdateMissesCounter() {
        return this.lacUpdateMissesCounter;
    }

    @Override
    public OpStatsLogger getClientChannelWriteWaitLogger() {
        return this.clientChannelWriteWaitStats;
    }

    @Override
    public Counter getEnsembleBookieDistributionCounter(String bookie) {
        return this.stats.scopeLabel("bookie", bookie).getCounter("LEDGER_ENSEMBLE_BOOKIE_DISTRIBUTION");
    }

    @Override
    public OpStatsLogger getWriteDelayedDueToNotEnoughFaultDomainsLatency() {
        return this.writeDelayedDueToNotEnoughFaultDomainsLatency;
    }

    @Override
    public Counter getWriteDelayedDueToNotEnoughFaultDomains() {
        return this.writeDelayedDueToNotEnoughFaultDomains;
    }

    @Override
    public Counter getWriteTimedOutDueToNotEnoughFaultDomains() {
        return this.writeTimedOutDueToNotEnoughFaultDomains;
    }

    @Override
    public void registerPendingAddsGauge(Gauge<Integer> gauge) {
        this.stats.registerGauge("NUM_PENDING_ADD", gauge);
    }
}

