/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.HashedWheelTimer;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.common.util.SharedResourceManager;
import org.apache.bookkeeper.stream.storage.StorageResourcesSpec;

public class StorageResources {
    private final SharedResourceManager.Resource<OrderedScheduler> scheduler;
    private final SharedResourceManager.Resource<OrderedScheduler> ioWriteScheduler;
    private final SharedResourceManager.Resource<OrderedScheduler> ioReadScheduler;
    private final SharedResourceManager.Resource<OrderedScheduler> checkpointScheduler;
    private final SharedResourceManager.Resource<HashedWheelTimer> timer;

    public static StorageResources create() {
        return StorageResources.create(StorageResourcesSpec.builder().build());
    }

    public static StorageResources create(StorageResourcesSpec spec) {
        return new StorageResources(spec);
    }

    private static SharedResourceManager.Resource<OrderedScheduler> createSchedulerResource(final String name, final int numThreads) {
        return new SharedResourceManager.Resource<OrderedScheduler>(){

            public OrderedScheduler create() {
                return (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(numThreads).name(name).build();
            }

            public void close(OrderedScheduler scheduler) {
                scheduler.shutdown();
            }

            public String toString() {
                return name;
            }
        };
    }

    private StorageResources(StorageResourcesSpec spec) {
        this.scheduler = StorageResources.createSchedulerResource("storage-scheduler", spec.numSchedulerThreads());
        this.ioWriteScheduler = StorageResources.createSchedulerResource("io-write-scheduler", spec.numIOWriteThreads());
        this.ioReadScheduler = StorageResources.createSchedulerResource("io-read-scheduler", spec.numIOReadThreads());
        this.checkpointScheduler = StorageResources.createSchedulerResource("io-checkpoint-scheduler", spec.numCheckpointThreads());
        this.timer = new SharedResourceManager.Resource<HashedWheelTimer>(){
            private static final String name = "storage-timer";

            public HashedWheelTimer create() {
                HashedWheelTimer timer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("storage-timer-%d").build(), 200L, TimeUnit.MILLISECONDS, 512, true);
                timer.start();
                return timer;
            }

            public void close(HashedWheelTimer instance) {
                instance.stop();
            }

            public String toString() {
                return name;
            }
        };
    }

    public SharedResourceManager.Resource<OrderedScheduler> scheduler() {
        return this.scheduler;
    }

    public SharedResourceManager.Resource<OrderedScheduler> ioWriteScheduler() {
        return this.ioWriteScheduler;
    }

    public SharedResourceManager.Resource<OrderedScheduler> ioReadScheduler() {
        return this.ioReadScheduler;
    }

    public SharedResourceManager.Resource<OrderedScheduler> checkpointScheduler() {
        return this.checkpointScheduler;
    }

    public SharedResourceManager.Resource<HashedWheelTimer> timer() {
        return this.timer;
    }
}

