/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import java.util.Map;
import lombok.Generated;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.pool.TypePool;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.functions.CryptoConfig;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.functions.api.SerDe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidatorUtils.class);
    private static final String DEFAULT_SERDE = "org.apache.pulsar.functions.api.utils.DefaultSerDe";

    public static void validateSchema(String schemaType, TypeDefinition typeArg, TypePool typePool, boolean input) {
        if (!StringUtils.isEmpty((CharSequence)schemaType) && ValidatorUtils.getBuiltinSchemaType(schemaType) == null) {
            TypeDescription schemaClass = null;
            try {
                schemaClass = typePool.describe(schemaType).resolve();
            }
            catch (TypePool.Resolution.NoSuchTypeException e) {
                throw new IllegalArgumentException(String.format("The schema class %s does not exist", schemaType));
            }
            if (!schemaClass.asErasure().isAssignableTo(Schema.class)) {
                throw new IllegalArgumentException(String.format("%s does not implement %s", schemaType, Schema.class.getName()));
            }
            ValidatorUtils.validateSchemaType((TypeDefinition)schemaClass, typeArg, typePool, input);
        }
    }

    private static SchemaType getBuiltinSchemaType(String schemaTypeOrClassName) {
        try {
            return SchemaType.valueOf((String)schemaTypeOrClassName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void validateCryptoKeyReader(CryptoConfig conf, TypePool typePool, boolean isProducer) {
        if (StringUtils.isEmpty((CharSequence)conf.getCryptoKeyReaderClassName())) {
            return;
        }
        String cryptoClassName = conf.getCryptoKeyReaderClassName();
        TypeDescription cryptoClass = null;
        try {
            cryptoClass = typePool.describe(cryptoClassName).resolve();
        }
        catch (TypePool.Resolution.NoSuchTypeException e) {
            throw new IllegalArgumentException(String.format("The crypto key reader class %s does not exist", cryptoClassName));
        }
        if (!cryptoClass.asErasure().isAssignableTo(CryptoKeyReader.class)) {
            throw new IllegalArgumentException(String.format("%s does not implement %s", cryptoClassName, CryptoKeyReader.class.getName()));
        }
        boolean hasConstructor = cryptoClass.getDeclaredMethods().stream().anyMatch(method -> method.isConstructor() && method.getParameters().size() == 1 && ((ParameterDescription.InDefinedShape)method.getParameters().get(0)).getType().asErasure().represents(Map.class));
        if (!hasConstructor) {
            throw new IllegalArgumentException(String.format("The crypto key reader class %s does not implement the desired constructor.", conf.getCryptoKeyReaderClassName()));
        }
        if (isProducer && (conf.getEncryptionKeys() == null || conf.getEncryptionKeys().length == 0)) {
            throw new IllegalArgumentException("Missing encryption key name for producer crypto key reader");
        }
    }

    public static void validateSerde(String inputSerializer, TypeDefinition typeArg, TypePool typePool, boolean deser) {
        TypeDescription serdeClass;
        if (StringUtils.isEmpty((CharSequence)inputSerializer)) {
            return;
        }
        if (inputSerializer.equals(DEFAULT_SERDE)) {
            return;
        }
        try {
            serdeClass = typePool.describe(inputSerializer).resolve();
        }
        catch (TypePool.Resolution.NoSuchTypeException e) {
            throw new IllegalArgumentException(String.format("The input serialization/deserialization class %s does not exist", inputSerializer));
        }
        TypeDescription.Generic serDeTypeArg = serdeClass.getInterfaces().stream().filter(i -> i.asErasure().isAssignableTo(SerDe.class)).findFirst().map(i -> (TypeDescription.Generic)i.getTypeArguments().get(0)).orElseThrow(() -> new IllegalArgumentException(String.format("%s does not implement %s", inputSerializer, SerDe.class.getName())));
        if (deser ? !serDeTypeArg.asErasure().isAssignableTo(typeArg.asErasure()) : !serDeTypeArg.asErasure().isAssignableFrom(typeArg.asErasure())) {
            throw new IllegalArgumentException("Serializer type mismatch " + typeArg.getActualName() + " vs " + serDeTypeArg.getActualName());
        }
    }

    private static void validateSchemaType(TypeDefinition schema, TypeDefinition typeArg, TypePool typePool, boolean input) {
        TypeDescription.Generic schemaTypeArg = schema.getInterfaces().stream().filter(i -> i.asErasure().isAssignableTo(Schema.class)).findFirst().map(i -> (TypeDescription.Generic)i.getTypeArguments().get(0)).orElse(null);
        if (input ? !schemaTypeArg.asErasure().isAssignableTo(typeArg.asErasure()) : !schemaTypeArg.asErasure().isAssignableFrom(typeArg.asErasure())) {
            throw new IllegalArgumentException("Schema type mismatch " + typeArg.getActualName() + " vs " + schemaTypeArg.getActualName());
        }
    }
}

