/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.distributedlog.BKAsyncLogWriter;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKLogReadHandler;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.ReadUtils;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.logsegment.LogSegmentEntryStore;
import org.apache.distributedlog.logsegment.LogSegmentFilter;
import org.apache.distributedlog.util.Utils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReadUtils
extends TestDistributedLogBase {
    static final Logger LOG = LoggerFactory.getLogger(TestReadUtils.class);
    @Rule
    public TestName runtime = new TestName();

    private CompletableFuture<Optional<LogRecordWithDLSN>> getLogRecordNotLessThanTxId(BKDistributedLogManager bkdlm, int logsegmentIdx, long transactionId) throws Exception {
        List logSegments = bkdlm.getLogSegments();
        return ReadUtils.getLogRecordNotLessThanTxId((String)bkdlm.getStreamName(), (LogSegmentMetadata)((LogSegmentMetadata)logSegments.get(logsegmentIdx)), (long)transactionId, (ExecutorService)Executors.newSingleThreadExecutor(), (LogSegmentEntryStore)bkdlm.getReaderEntryStore(), (int)10);
    }

    private CompletableFuture<LogRecordWithDLSN> getFirstGreaterThanRecord(BKDistributedLogManager bkdlm, int ledgerNo, DLSN dlsn) throws Exception {
        List ledgerList = bkdlm.getLogSegments();
        return ReadUtils.asyncReadFirstUserRecord((String)bkdlm.getStreamName(), (LogSegmentMetadata)((LogSegmentMetadata)ledgerList.get(ledgerNo)), (int)2, (int)16, (AtomicInteger)new AtomicInteger(0), (ExecutorService)Executors.newFixedThreadPool(1), (LogSegmentEntryStore)bkdlm.getReaderEntryStore(), (DLSN)dlsn);
    }

    private CompletableFuture<LogRecordWithDLSN> getLastUserRecord(BKDistributedLogManager bkdlm, int ledgerNo) throws Exception {
        BKLogReadHandler readHandler = bkdlm.createReadHandler();
        List ledgerList = (List)((Versioned)Utils.ioResult((CompletableFuture)readHandler.readLogSegmentsFromStore(LogSegmentMetadata.COMPARATOR, LogSegmentFilter.DEFAULT_FILTER, null))).getValue();
        return ReadUtils.asyncReadLastRecord((String)bkdlm.getStreamName(), (LogSegmentMetadata)((LogSegmentMetadata)ledgerList.get(ledgerNo)), (boolean)false, (boolean)false, (boolean)false, (int)2, (int)16, (AtomicInteger)new AtomicInteger(0), (ExecutorService)Executors.newFixedThreadPool(1), (LogSegmentEntryStore)bkdlm.getReaderEntryStore());
    }

    @Test(timeout=60000L)
    public void testForwardScanFirstRecord() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 0, 5, 1L);
        DLSN dlsn = new DLSN(1L, 0L, 0L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getFirstGreaterThanRecord(bkdlm, 0, dlsn);
        LogRecordWithDLSN logrec = (LogRecordWithDLSN)Utils.ioResult(futureLogrec);
        Assert.assertEquals((String)"should be an exact match", (Object)dlsn, (Object)logrec.getDlsn());
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testForwardScanNotFirstRecord() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 0, 5, 1L);
        DLSN dlsn = new DLSN(1L, 1L, 0L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getFirstGreaterThanRecord(bkdlm, 0, dlsn);
        LogRecordWithDLSN logrec = (LogRecordWithDLSN)Utils.ioResult(futureLogrec);
        Assert.assertEquals((String)"should be an exact match", (Object)dlsn, (Object)logrec.getDlsn());
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testForwardScanValidButNonExistentRecord() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 0, 5, 1L);
        DLSN dlsn = new DLSN(1L, 0L, 1L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getFirstGreaterThanRecord(bkdlm, 0, dlsn);
        LogRecordWithDLSN logrec = (LogRecordWithDLSN)Utils.ioResult(futureLogrec);
        Assert.assertEquals((Object)new DLSN(1L, 1L, 0L), (Object)logrec.getDlsn());
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testForwardScanForRecordAfterLedger() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 0, 5, 1L);
        DLSN dlsn = new DLSN(2L, 0L, 0L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getFirstGreaterThanRecord(bkdlm, 0, dlsn);
        LogRecordWithDLSN logrec = (LogRecordWithDLSN)Utils.ioResult(futureLogrec);
        Assert.assertEquals(null, (Object)logrec);
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testForwardScanForRecordBeforeLedger() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        long txid = 1L;
        txid += DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 0, 5, txid);
        txid += DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 0, 5, txid);
        txid += DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 0, 5, txid);
        DLSN dlsn = new DLSN(1L, 3L, 0L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getFirstGreaterThanRecord(bkdlm, 1, dlsn);
        LogRecordWithDLSN logrec = (LogRecordWithDLSN)Utils.ioResult(futureLogrec);
        Assert.assertEquals((Object)new DLSN(2L, 0L, 0L), (Object)logrec.getDlsn());
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testForwardScanControlRecord() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 5, 5, 1L);
        DLSN dlsn = new DLSN(1L, 3L, 0L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getFirstGreaterThanRecord(bkdlm, 0, dlsn);
        LogRecordWithDLSN logrec = (LogRecordWithDLSN)Utils.ioResult(futureLogrec);
        Assert.assertEquals((Object)new DLSN(1L, 5L, 0L), (Object)logrec.getDlsn());
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testGetLastRecordUserRecord() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 5, 5, 1L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getLastUserRecord(bkdlm, 0);
        LogRecordWithDLSN logrec = (LogRecordWithDLSN)Utils.ioResult(futureLogrec);
        Assert.assertEquals((Object)new DLSN(1L, 9L, 0L), (Object)logrec.getDlsn());
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testGetLastRecordControlRecord() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        BKAsyncLogWriter out = bkdlm.startAsyncLogSegmentNonPartitioned();
        int txid = 1;
        Utils.ioResult((CompletableFuture)out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, false)));
        Utils.ioResult((CompletableFuture)out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, false)));
        Utils.ioResult((CompletableFuture)out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, false)));
        Utils.ioResult((CompletableFuture)out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, true)));
        Utils.ioResult((CompletableFuture)out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, true)));
        Utils.close((AsyncCloseable)out);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getLastUserRecord(bkdlm, 0);
        LogRecordWithDLSN logrec = (LogRecordWithDLSN)Utils.ioResult(futureLogrec);
        Assert.assertEquals((Object)new DLSN(1L, 2L, 0L), (Object)logrec.getDlsn());
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testGetLastRecordAllControlRecords() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 5, 0, 1L);
        CompletableFuture<LogRecordWithDLSN> futureLogrec = this.getLastUserRecord(bkdlm, 0);
        LogRecordWithDLSN logrec = (LogRecordWithDLSN)Utils.ioResult(futureLogrec);
        Assert.assertEquals(null, (Object)logrec);
        bkdlm.close();
    }

    @Test(timeout=60000L)
    public void testGetEntriesToSearch() throws Exception {
        Assert.assertTrue((boolean)ReadUtils.getEntriesToSearch((long)2L, (long)1L, (int)10).isEmpty());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{1L}), (Object)ReadUtils.getEntriesToSearch((long)1L, (long)1L, (int)10));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L}), (Object)ReadUtils.getEntriesToSearch((long)1L, (long)10L, (int)10));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L}), (Object)ReadUtils.getEntriesToSearch((long)1L, (long)9L, (int)10));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L}), (Object)ReadUtils.getEntriesToSearch((long)1L, (long)8L, (int)10));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 11L}), (Object)ReadUtils.getEntriesToSearch((long)1L, (long)11L, (int)10));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 12L}), (Object)ReadUtils.getEntriesToSearch((long)1L, (long)12L, (int)10));
    }

    @Test(timeout=60000L)
    public void testGetEntriesToSearchByTxnId() throws Exception {
        LogRecordWithDLSN firstRecord = DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, 0L, 0L), 999L);
        LogRecordWithDLSN secondRecord = DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, 10L, 0L), 99L);
        LogRecordWithDLSN thirdRecord = DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, 100L, 0L), 1099L);
        Assert.assertTrue((boolean)ReadUtils.getEntriesToSearch((long)888L, (LogRecordWithDLSN)firstRecord, (LogRecordWithDLSN)secondRecord, (int)10).isEmpty());
        Assert.assertTrue((boolean)ReadUtils.getEntriesToSearch((long)888L, (LogRecordWithDLSN)firstRecord, (LogRecordWithDLSN)firstRecord, (int)10).isEmpty());
        Assert.assertEquals((long)2L, (long)ReadUtils.getEntriesToSearch((long)888L, (LogRecordWithDLSN)firstRecord, (LogRecordWithDLSN)thirdRecord, (int)2).size());
        Assert.assertEquals((long)3L, (long)ReadUtils.getEntriesToSearch((long)1099L, (LogRecordWithDLSN)firstRecord, (LogRecordWithDLSN)thirdRecord, (int)2).size());
        LogRecordWithDLSN record1 = DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, 0L, 0L), 88L);
        LogRecordWithDLSN record2 = DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, 12L, 0L), 888L);
        LogRecordWithDLSN record3 = DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, 12L, 0L), 999L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 10L, 11L}), (Object)ReadUtils.getEntriesToSearch((long)888L, (LogRecordWithDLSN)record1, (LogRecordWithDLSN)record2, (int)10));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 11L}), (Object)ReadUtils.getEntriesToSearch((long)888L, (LogRecordWithDLSN)record1, (LogRecordWithDLSN)record3, (int)10));
    }

    @Test(timeout=60000L)
    public void testGetLogRecordNotLessThanTxIdWithGreaterTxId() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 0, 1, 1L);
        Optional result = (Optional)Utils.ioResult(this.getLogRecordNotLessThanTxId(bkdlm, 0, 999L));
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test(timeout=60000L)
    public void testGetLogRecordNotLessThanTxIdWithLessTxId() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 0, 1, 999L);
        Optional result = (Optional)Utils.ioResult(this.getLogRecordNotLessThanTxId(bkdlm, 0, 99L));
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((long)999L, (long)((LogRecordWithDLSN)result.get()).getTransactionId());
        Assert.assertEquals((long)0L, (long)((LogRecordWithDLSN)result.get()).getDlsn().getEntryId());
        Assert.assertEquals((long)0L, (long)((LogRecordWithDLSN)result.get()).getDlsn().getSlotId());
    }

    @Test(timeout=60000L)
    public void testGetLogRecordNotLessThanTxIdOnSmallSegment() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 0, 5, 1L);
        Optional result = (Optional)Utils.ioResult(this.getLogRecordNotLessThanTxId(bkdlm, 0, 3L));
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((long)3L, (long)((LogRecordWithDLSN)result.get()).getTransactionId());
    }

    @Test(timeout=60000L)
    public void testGetLogRecordNotLessThanTxIdOnLargeSegment() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 0, 100, 1L);
        Optional result = (Optional)Utils.ioResult(this.getLogRecordNotLessThanTxId(bkdlm, 0, 9L));
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((long)9L, (long)((LogRecordWithDLSN)result.get()).getTransactionId());
    }

    @Test(timeout=60000L)
    public void testGetLogRecordGreaterThanTxIdOnLargeSegment() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 0, 100, 1L, 3L);
        Optional result = (Optional)Utils.ioResult(this.getLogRecordNotLessThanTxId(bkdlm, 0, 23L));
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((long)25L, (long)((LogRecordWithDLSN)result.get()).getTransactionId());
    }

    @Test(timeout=60000L)
    public void testGetLogRecordGreaterThanTxIdOnSameTxId() throws Exception {
        LogRecord record;
        int i;
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        BKAsyncLogWriter out = bkdlm.startAsyncLogSegmentNonPartitioned();
        long txid = 1L;
        for (int i2 = 0; i2 < 10; ++i2) {
            LogRecord record2 = DLMTestUtil.getLargeLogRecordInstance(txid);
            Utils.ioResult((CompletableFuture)out.write(record2));
            ++txid;
        }
        long txidToSearch = txid;
        for (i = 0; i < 10; ++i) {
            record = DLMTestUtil.getLargeLogRecordInstance(txidToSearch);
            Utils.ioResult((CompletableFuture)out.write(record));
        }
        for (i = 0; i < 10; ++i) {
            record = DLMTestUtil.getLargeLogRecordInstance(txid);
            Utils.ioResult((CompletableFuture)out.write(record));
            ++txid;
        }
        Utils.close((AsyncCloseable)out);
        Optional result = (Optional)Utils.ioResult(this.getLogRecordNotLessThanTxId(bkdlm, 0, txidToSearch));
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((long)10L, (long)((LogRecordWithDLSN)result.get()).getDlsn().getEntryId());
    }
}

