/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.metadata;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.TestZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClusterTestCase;
import org.apache.distributedlog.impl.ZKLogSegmentMetadataStore;
import org.apache.distributedlog.logsegment.LogSegmentMetadataStore;
import org.apache.distributedlog.metadata.DryrunLogSegmentMetadataStoreUpdater;
import org.apache.distributedlog.metadata.LogSegmentMetadataStoreUpdater;
import org.apache.distributedlog.metadata.MetadataUpdater;
import org.apache.distributedlog.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLogSegmentMetadataStoreUpdater
extends ZooKeeperClusterTestCase {
    static final Logger LOG = LoggerFactory.getLogger(TestLogSegmentMetadataStoreUpdater.class);
    private ZooKeeperClient zkc;
    private OrderedScheduler scheduler;
    private LogSegmentMetadataStore metadataStore;
    private DistributedLogConfiguration conf = new DistributedLogConfiguration().setDLLedgerMetadataLayoutVersion(LogSegmentMetadata.LEDGER_METADATA_CURRENT_LAYOUT_VERSION);

    @Before
    public void setup() throws Exception {
        this.scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test-logsegment-metadata-store-updater").numThreads(1).build();
        this.zkc = TestZooKeeperClientBuilder.newBuilder().uri(this.createURI("/")).sessionTimeoutMs(10000).build();
        this.metadataStore = new ZKLogSegmentMetadataStore(this.conf, this.zkc, this.scheduler);
    }

    @After
    public void tearDown() throws Exception {
        this.metadataStore.close();
        this.scheduler.shutdown();
        this.zkc.close();
    }

    private URI createURI(String path) {
        return URI.create("distributedlog://127.0.0.1:" + zkPort + path);
    }

    Map<Long, LogSegmentMetadata> readLogSegments(String ledgerPath) throws Exception {
        return DLMTestUtil.readLogSegments(this.zkc, ledgerPath);
    }

    @Test(timeout=60000L)
    public void testChangeSequenceNumber() throws Exception {
        String ledgerPath = "/testChangeSequenceNumber";
        this.zkc.get().create(ledgerPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        HashMap<Long, LogSegmentMetadata> completedLogSegments = new HashMap<Long, LogSegmentMetadata>();
        for (int i = 1; i <= 5; ++i) {
            LogSegmentMetadata segment = DLMTestUtil.completedLogSegment(ledgerPath, i, (i - 1) * 100, i * 100 - 1, 100, i, 100L, 0L);
            completedLogSegments.put(Long.valueOf(i), segment);
            LOG.info("Create completed segment {} : {}", (Object)segment.getZkPath(), (Object)segment);
            segment.write(this.zkc);
        }
        long inprogressSeqNo = 3L;
        LogSegmentMetadata segment = DLMTestUtil.inprogressLogSegment(ledgerPath, inprogressSeqNo, 500L, inprogressSeqNo);
        LOG.info("Create inprogress segment {} : {}", (Object)segment.getZkPath(), (Object)segment);
        segment.write(this.zkc);
        Map<Long, LogSegmentMetadata> segmentList = this.readLogSegments(ledgerPath);
        Assert.assertEquals((long)5L, (long)segmentList.size());
        DryrunLogSegmentMetadataStoreUpdater dryrunUpdater = new DryrunLogSegmentMetadataStoreUpdater(this.conf, this.metadataStore);
        Utils.ioResult((CompletableFuture)dryrunUpdater.changeSequenceNumber(segment, 6L));
        segmentList = this.readLogSegments(ledgerPath);
        Assert.assertEquals((long)5L, (long)segmentList.size());
        MetadataUpdater updater = LogSegmentMetadataStoreUpdater.createMetadataUpdater((DistributedLogConfiguration)this.conf, (LogSegmentMetadataStore)this.metadataStore);
        Utils.ioResult((CompletableFuture)updater.changeSequenceNumber(segment, 6L));
        segmentList = this.readLogSegments(ledgerPath);
        Assert.assertEquals((long)6L, (long)segmentList.size());
        for (int i = 1; i <= 5; ++i) {
            LogSegmentMetadata s = segmentList.get(i);
            Assert.assertNotNull((Object)s);
            Assert.assertEquals(completedLogSegments.get(i), (Object)s);
        }
        LogSegmentMetadata segmentChanged = segmentList.get(6L);
        Assert.assertNotNull((Object)segmentChanged);
        Assert.assertEquals((long)6L, (long)segmentChanged.getLogSegmentSequenceNumber());
        Assert.assertTrue((boolean)segmentChanged.isInProgress());
        Assert.assertEquals((long)500L, (long)segmentChanged.getFirstTxId());
        Assert.assertEquals((long)3L, (long)segmentChanged.getLogSegmentId());
    }

    @Test(timeout=60000L)
    public void testUpdateLastDLSN() throws Exception {
        String ledgerPath = "/testUpdateLastDLSN";
        this.zkc.get().create(ledgerPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        LogSegmentMetadata completedLogSegment = DLMTestUtil.completedLogSegment(ledgerPath, 1L, 0L, 99L, 100, 1L, 99L, 0L);
        completedLogSegment.write(this.zkc);
        LogSegmentMetadata inprogressLogSegment = DLMTestUtil.inprogressLogSegment(ledgerPath, 2L, 100L, 2L);
        inprogressLogSegment.write(this.zkc);
        DLSN badLastDLSN = new DLSN(99L, 0L, 0L);
        DLSN goodLastDLSN1 = new DLSN(1L, 100L, 0L);
        DLSN goodLastDLSN2 = new DLSN(2L, 200L, 0L);
        LogRecordWithDLSN badRecord = DLMTestUtil.getLogRecordWithDLSNInstance(badLastDLSN, 100L);
        LogRecordWithDLSN goodRecord1 = DLMTestUtil.getLogRecordWithDLSNInstance(goodLastDLSN1, 100L);
        LogRecordWithDLSN goodRecord2 = DLMTestUtil.getLogRecordWithDLSNInstance(goodLastDLSN2, 200L);
        DryrunLogSegmentMetadataStoreUpdater dryrunUpdater = new DryrunLogSegmentMetadataStoreUpdater(this.conf, this.metadataStore);
        try {
            Utils.ioResult((CompletableFuture)dryrunUpdater.updateLastRecord(completedLogSegment, badRecord));
            Assert.fail((String)"Should fail on updating dlsn that in different log segment");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Utils.ioResult((CompletableFuture)dryrunUpdater.updateLastRecord(inprogressLogSegment, goodRecord2));
            Assert.fail((String)"Should fail on updating dlsn for an inprogress log segment");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        LogSegmentMetadata updatedCompletedLogSegment = (LogSegmentMetadata)Utils.ioResult((CompletableFuture)dryrunUpdater.updateLastRecord(completedLogSegment, goodRecord1));
        Assert.assertEquals((Object)goodLastDLSN1, (Object)updatedCompletedLogSegment.getLastDLSN());
        Assert.assertEquals((long)goodRecord1.getTransactionId(), (long)updatedCompletedLogSegment.getLastTxId());
        Assert.assertTrue((boolean)updatedCompletedLogSegment.isRecordLastPositioninThisSegment((LogRecord)goodRecord1));
        Map<Long, LogSegmentMetadata> segmentList = this.readLogSegments(ledgerPath);
        Assert.assertEquals((long)2L, (long)segmentList.size());
        LogSegmentMetadata readCompletedLogSegment = segmentList.get(1L);
        Assert.assertNotNull((Object)readCompletedLogSegment);
        Assert.assertEquals((Object)completedLogSegment, (Object)readCompletedLogSegment);
        LogSegmentMetadata readInprogressLogSegment = segmentList.get(2L);
        Assert.assertNotNull((Object)readInprogressLogSegment);
        Assert.assertEquals((Object)inprogressLogSegment, (Object)readInprogressLogSegment);
        MetadataUpdater updater = LogSegmentMetadataStoreUpdater.createMetadataUpdater((DistributedLogConfiguration)this.conf, (LogSegmentMetadataStore)this.metadataStore);
        try {
            Utils.ioResult((CompletableFuture)updater.updateLastRecord(completedLogSegment, badRecord));
            Assert.fail((String)"Should fail on updating dlsn that in different log segment");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Utils.ioResult((CompletableFuture)updater.updateLastRecord(inprogressLogSegment, goodRecord2));
            Assert.fail((String)"Should fail on updating dlsn for an inprogress log segment");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        updatedCompletedLogSegment = (LogSegmentMetadata)Utils.ioResult((CompletableFuture)updater.updateLastRecord(completedLogSegment, goodRecord1));
        Assert.assertEquals((Object)goodLastDLSN1, (Object)updatedCompletedLogSegment.getLastDLSN());
        Assert.assertEquals((long)goodRecord1.getTransactionId(), (long)updatedCompletedLogSegment.getLastTxId());
        Assert.assertTrue((boolean)updatedCompletedLogSegment.isRecordLastPositioninThisSegment((LogRecord)goodRecord1));
        segmentList = this.readLogSegments(ledgerPath);
        Assert.assertEquals((long)2L, (long)segmentList.size());
        readCompletedLogSegment = segmentList.get(1L);
        Assert.assertNotNull((Object)readCompletedLogSegment);
        Assert.assertEquals((Object)goodLastDLSN1, (Object)readCompletedLogSegment.getLastDLSN());
        Assert.assertEquals((long)goodRecord1.getTransactionId(), (long)readCompletedLogSegment.getLastTxId());
        Assert.assertTrue((boolean)readCompletedLogSegment.isRecordLastPositioninThisSegment((LogRecord)goodRecord1));
        Assert.assertEquals((Object)updatedCompletedLogSegment, (Object)readCompletedLogSegment);
        Assert.assertEquals((long)completedLogSegment.getCompletionTime(), (long)readCompletedLogSegment.getCompletionTime());
        Assert.assertEquals((long)completedLogSegment.getFirstTxId(), (long)readCompletedLogSegment.getFirstTxId());
        Assert.assertEquals((long)completedLogSegment.getLogSegmentId(), (long)readCompletedLogSegment.getLogSegmentId());
        Assert.assertEquals((long)completedLogSegment.getLogSegmentSequenceNumber(), (long)readCompletedLogSegment.getLogSegmentSequenceNumber());
        Assert.assertEquals((long)completedLogSegment.getRegionId(), (long)readCompletedLogSegment.getRegionId());
        Assert.assertEquals((Object)completedLogSegment.getZkPath(), (Object)readCompletedLogSegment.getZkPath());
        Assert.assertEquals((Object)completedLogSegment.getZNodeName(), (Object)readCompletedLogSegment.getZNodeName());
        readInprogressLogSegment = segmentList.get(2L);
        Assert.assertNotNull((Object)readInprogressLogSegment);
        Assert.assertEquals((Object)inprogressLogSegment, (Object)readInprogressLogSegment);
    }

    @Test(timeout=60000L)
    public void testChangeTruncationStatus() throws Exception {
        String ledgerPath = "/ledgers2";
        this.zkc.get().create(ledgerPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        HashMap<Long, LogSegmentMetadata> completedLogSegments = new HashMap<Long, LogSegmentMetadata>();
        for (int i = 1; i <= 5; ++i) {
            LogSegmentMetadata segment = DLMTestUtil.completedLogSegment(ledgerPath, i, (i - 1) * 100, i * 100 - 1, 100, i, 100L, 0L);
            completedLogSegments.put(Long.valueOf(i), segment);
            LOG.info("Create completed segment {} : {}", (Object)segment.getZkPath(), (Object)segment);
            segment.write(this.zkc);
        }
        Map<Long, LogSegmentMetadata> segmentList = this.readLogSegments(ledgerPath);
        Assert.assertEquals((long)5L, (long)segmentList.size());
        long segmentToModify = 1L;
        DryrunLogSegmentMetadataStoreUpdater dryrunUpdater = new DryrunLogSegmentMetadataStoreUpdater(this.conf, this.metadataStore);
        Utils.ioResult((CompletableFuture)dryrunUpdater.setLogSegmentTruncated(segmentList.get(segmentToModify)));
        segmentList = this.readLogSegments(ledgerPath);
        Assert.assertEquals((Object)false, (Object)segmentList.get(segmentToModify).isTruncated());
        MetadataUpdater updater = LogSegmentMetadataStoreUpdater.createMetadataUpdater((DistributedLogConfiguration)this.conf, (LogSegmentMetadataStore)this.metadataStore);
        Utils.ioResult((CompletableFuture)updater.setLogSegmentTruncated(segmentList.get(segmentToModify)));
        segmentList = this.readLogSegments(ledgerPath);
        Assert.assertEquals((Object)true, (Object)segmentList.get(segmentToModify).isTruncated());
        Assert.assertEquals((Object)false, (Object)segmentList.get(segmentToModify).isPartiallyTruncated());
        updater = LogSegmentMetadataStoreUpdater.createMetadataUpdater((DistributedLogConfiguration)this.conf, (LogSegmentMetadataStore)this.metadataStore);
        Utils.ioResult((CompletableFuture)updater.setLogSegmentActive(segmentList.get(segmentToModify)));
        segmentList = this.readLogSegments(ledgerPath);
        Assert.assertEquals((Object)false, (Object)segmentList.get(segmentToModify).isTruncated());
        Assert.assertEquals((Object)false, (Object)segmentList.get(segmentToModify).isPartiallyTruncated());
        updater = LogSegmentMetadataStoreUpdater.createMetadataUpdater((DistributedLogConfiguration)this.conf, (LogSegmentMetadataStore)this.metadataStore);
        Utils.ioResult((CompletableFuture)updater.setLogSegmentPartiallyTruncated(segmentList.get(segmentToModify), segmentList.get(segmentToModify).getFirstDLSN()));
        segmentList = this.readLogSegments(ledgerPath);
        Assert.assertEquals((Object)false, (Object)segmentList.get(segmentToModify).isTruncated());
        Assert.assertEquals((Object)true, (Object)segmentList.get(segmentToModify).isPartiallyTruncated());
        updater = LogSegmentMetadataStoreUpdater.createMetadataUpdater((DistributedLogConfiguration)this.conf, (LogSegmentMetadataStore)this.metadataStore);
        Utils.ioResult((CompletableFuture)updater.setLogSegmentActive(segmentList.get(segmentToModify)));
        segmentList = this.readLogSegments(ledgerPath);
        Assert.assertEquals((Object)false, (Object)segmentList.get(segmentToModify).isTruncated());
        Assert.assertEquals((Object)false, (Object)segmentList.get(segmentToModify).isPartiallyTruncated());
    }
}

