/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.channel;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.extensions.ExtensibleLoadManagerImpl;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateData;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateDataConflictResolver;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateTableViewBase;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TableView;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUnitStateTableViewImpl
extends ServiceUnitStateTableViewBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceUnitStateTableViewImpl.class);
    public static final String TOPIC = TopicName.get((String)TopicDomain.persistent.value(), (NamespaceName)NamespaceName.SYSTEM_NAMESPACE, (String)"loadbalancer-service-unit-state").toString();
    private static final int MAX_OUTSTANDING_PUB_MESSAGES = 500;
    public static final CompressionType MSG_COMPRESSION_TYPE = CompressionType.ZSTD;
    private volatile Producer<ServiceUnitStateData> producer;
    private volatile TableView<ServiceUnitStateData> tableview;

    @Override
    public void start(PulsarService pulsar, BiConsumer<String, ServiceUnitStateData> tailItemListener, BiConsumer<String, ServiceUnitStateData> existingItemListener, BiConsumer<String, ServiceUnitStateData> itemOutdatedListeners) throws IOException {
        boolean debug = ExtensibleLoadManagerImpl.debug(pulsar.getConfiguration(), log);
        this.init(pulsar);
        Schema schema = Schema.JSON(ServiceUnitStateData.class);
        ExtensibleLoadManagerImpl.createSystemTopic(pulsar, TOPIC);
        if (this.producer != null) {
            this.producer.close();
            if (debug) {
                log.info("Closed the channel producer.");
            }
        }
        this.producer = pulsar.getClient().newProducer(schema).enableBatching(true).compressionType(MSG_COMPRESSION_TYPE).maxPendingMessages(500).blockIfQueueFull(true).topic(TOPIC).create();
        if (debug) {
            log.info("Successfully started the channel producer.");
        }
        if (this.tableview != null) {
            this.tableview.close();
            if (debug) {
                log.info("Closed the channel tableview.");
            }
        }
        this.tableview = pulsar.getClient().newTableViewBuilder(schema).topic(TOPIC).loadConf(Map.of("topicCompactionStrategyClassName", ServiceUnitStateDataConflictResolver.class.getName())).create();
        this.tableview.listen(this::updateOwnedServiceUnits);
        this.tableview.listen(tailItemListener);
        this.tableview.forEach(this::updateOwnedServiceUnits);
        this.tableview.forEach(existingItemListener);
    }

    private boolean isValidState() {
        return this.tableview != null && this.producer != null;
    }

    @Override
    public void close() throws IOException {
        if (this.tableview != null) {
            this.tableview.close();
            this.tableview = null;
            log.info("Successfully closed the channel tableview.");
        }
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
            log.info("Successfully closed the channel producer.");
        }
    }

    @Override
    public ServiceUnitStateData get(String key) {
        if (!this.isValidState()) {
            throw new IllegalStateException("The tableview has not been started.");
        }
        return (ServiceUnitStateData)this.tableview.get(key);
    }

    @Override
    public CompletableFuture<Void> put(String key, ServiceUnitStateData value) {
        if (!this.isValidState()) {
            return CompletableFuture.failedFuture(new IllegalStateException("The tableview has not been started."));
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.producer.newMessage().key(key).value((Object)value).sendAsync().whenComplete((messageId, e) -> {
            if (e != null) {
                if (e instanceof PulsarClientException.AlreadyClosedException) {
                    log.info("Skip publishing the message since the producer is closed, serviceUnit: {}, data: {}", (Object)key, (Object)value);
                } else {
                    log.error("Failed to publish the message: serviceUnit:{}, data:{}", new Object[]{key, value, e});
                }
                future.completeExceptionally((Throwable)e);
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    @Override
    public void flush(long waitDurationInMillis) throws InterruptedException, TimeoutException, ExecutionException {
        if (!this.isValidState()) {
            throw new IllegalStateException("The tableview has not been started.");
        }
        long deadline = System.currentTimeMillis() + waitDurationInMillis;
        long waitTimeMs = waitDurationInMillis;
        this.producer.flushAsync().get(waitTimeMs, TimeUnit.MILLISECONDS);
        waitTimeMs = deadline - System.currentTimeMillis();
        if (waitTimeMs < 0L) {
            waitTimeMs = 0L;
        }
        this.tableview.refreshAsync().get(waitTimeMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isMetadataStoreBased() {
        return false;
    }

    @Override
    public CompletableFuture<Void> delete(String key) {
        return this.put(key, null);
    }

    @Override
    public Set<Map.Entry<String, ServiceUnitStateData>> entrySet() {
        if (!this.isValidState()) {
            throw new IllegalStateException("The tableview has not been started.");
        }
        return this.tableview.entrySet();
    }
}

