/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.util.concurrent.FastThreadLocal;
import java.net.InetSocketAddress;

final class ThreadLocalNameServerAddressStream
implements DnsServerAddressStream {
    private final String hostname;
    private final DnsServerAddressStreamProvider dnsServerAddressStreamProvider;
    private final FastThreadLocal<DnsServerAddressStream> threadLocal = new FastThreadLocal<DnsServerAddressStream>(){

        protected DnsServerAddressStream initialValue() {
            return ThreadLocalNameServerAddressStream.this.dnsServerAddressStreamProvider.nameServerAddressStream(ThreadLocalNameServerAddressStream.this.hostname);
        }
    };

    ThreadLocalNameServerAddressStream(DnsServerAddressStreamProvider dnsServerAddressStreamProvider) {
        this(dnsServerAddressStreamProvider, "");
    }

    ThreadLocalNameServerAddressStream(DnsServerAddressStreamProvider dnsServerAddressStreamProvider, String hostname) {
        this.dnsServerAddressStreamProvider = dnsServerAddressStreamProvider;
        this.hostname = hostname;
    }

    @Override
    public InetSocketAddress next() {
        return ((DnsServerAddressStream)this.threadLocal.get()).next();
    }

    @Override
    public DnsServerAddressStream duplicate() {
        return new ThreadLocalNameServerAddressStream(this.dnsServerAddressStreamProvider, this.hostname);
    }

    @Override
    public int size() {
        return ((DnsServerAddressStream)this.threadLocal.get()).size();
    }
}

