/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.auth.VertxContextPRNG;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.AbstractSession;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.impl.SharedDataSessionImpl;
import java.util.HashSet;

public class LocalSessionStoreImpl
implements SessionStore,
LocalSessionStore,
Handler<Long> {
    private static final long DEFAULT_REAPER_INTERVAL = 1000L;
    private static final String DEFAULT_SESSION_MAP_NAME = "vertx-web.sessions";
    private LocalMap<String, Session> localMap;
    private long reaperInterval;
    private VertxContextPRNG random;
    private long timerID = -1L;
    private boolean closed;
    private VertxInternal vertx;

    @Override
    public Session createSession(long timeout) {
        return new SharedDataSessionImpl(this.random, timeout, 16);
    }

    @Override
    public Session createSession(long timeout, int length) {
        return new SharedDataSessionImpl(this.random, timeout, length);
    }

    @Override
    public SessionStore init(Vertx vertx, JsonObject options) {
        this.random = VertxContextPRNG.current((Vertx)vertx);
        this.vertx = (VertxInternal)vertx;
        this.reaperInterval = options.getLong("reaperInterval", Long.valueOf(1000L));
        this.localMap = vertx.sharedData().getLocalMap(options.getString("mapName", DEFAULT_SESSION_MAP_NAME));
        this.setTimer();
        return this;
    }

    @Override
    public long retryTimeout() {
        return 0L;
    }

    @Override
    public Future<@Nullable Session> get(String id) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        return ctx.succeededFuture(this.localMap.get((Object)id));
    }

    @Override
    public Future<Void> delete(String id) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        this.localMap.remove((Object)id);
        return ctx.succeededFuture();
    }

    @Override
    public Future<Void> put(Session session) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        AbstractSession oldSession = (AbstractSession)this.localMap.get((Object)session.id());
        AbstractSession newSession = (AbstractSession)session;
        if (oldSession != null && oldSession.version() != newSession.version()) {
            return ctx.failedFuture("Session version mismatch");
        }
        newSession.incrementVersion();
        this.localMap.put((Object)session.id(), (Object)session);
        return ctx.succeededFuture();
    }

    @Override
    public Future<Void> clear() {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        this.localMap.clear();
        return ctx.succeededFuture();
    }

    @Override
    public Future<Integer> size() {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        return ctx.succeededFuture((Object)this.localMap.size());
    }

    @Override
    public synchronized void close() {
        this.localMap.close();
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        this.closed = true;
    }

    public synchronized void handle(Long tid) {
        long now = System.currentTimeMillis();
        HashSet toRemove = new HashSet();
        this.localMap.forEach((id, session) -> {
            if (now - session.lastAccessed() > session.timeout()) {
                toRemove.add(id);
            }
        });
        for (String id2 : toRemove) {
            this.localMap.remove((Object)id2);
        }
        if (!this.closed) {
            this.setTimer();
        }
    }

    private void setTimer() {
        if (this.reaperInterval != 0L) {
            this.timerID = this.vertx.setTimer(this.reaperInterval, (Handler)this);
        }
    }
}

