/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.common.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerUtils {
    private static final Logger log = LoggerFactory.getLogger(SchedulerUtils.class);

    public static void shutdownScheduler(ExecutorService service, long timeout, TimeUnit timeUnit) {
        if (null == service) {
            return;
        }
        service.shutdown();
        try {
            service.awaitTermination(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Interrupted when shutting down scheduler : ", (Throwable)e);
        }
        service.shutdownNow();
    }
}

