/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.options;

import io.oxia.client.api.GetOption;
import io.oxia.client.api.OptionComparisonType;
import io.oxia.client.api.OptionIncludeValue;
import io.oxia.client.api.OptionPartitionKey;
import io.oxia.client.api.OptionSecondaryIndexName;
import io.oxia.proto.KeyComparisonType;
import java.util.Set;

public record GetOptions(String partitionKey, boolean includeValue, KeyComparisonType comparisonType, String secondaryIndexName) {
    public static GetOptions parseFrom(Set<GetOption> options) {
        boolean includeValue = true;
        KeyComparisonType comparisonType = KeyComparisonType.EQUAL;
        String partitionKey = null;
        String secondaryIndexName = null;
        for (GetOption option : options) {
            if (option instanceof OptionIncludeValue) {
                includeValue = ((OptionIncludeValue)option).includeValue();
                continue;
            }
            if (option instanceof OptionComparisonType) {
                comparisonType = switch (((OptionComparisonType)option).comparisonType()) {
                    case OptionComparisonType.ComparisonType.Floor -> KeyComparisonType.FLOOR;
                    case OptionComparisonType.ComparisonType.Lower -> KeyComparisonType.LOWER;
                    case OptionComparisonType.ComparisonType.Higher -> KeyComparisonType.HIGHER;
                    case OptionComparisonType.ComparisonType.Ceiling -> KeyComparisonType.CEILING;
                    default -> KeyComparisonType.EQUAL;
                };
                continue;
            }
            if (option instanceof OptionPartitionKey) {
                partitionKey = ((OptionPartitionKey)option).partitionKey();
                continue;
            }
            if (!(option instanceof OptionSecondaryIndexName)) continue;
            secondaryIndexName = ((OptionSecondaryIndexName)option).secondaryIndexName();
        }
        return new GetOptions(partitionKey, includeValue, comparisonType, secondaryIndexName);
    }
}

