/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed;

import com.google.common.annotations.VisibleForTesting;
import io.netty.util.Timer;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.time.Clock;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.pulsar.broker.delayed.AbstractDelayedDeliveryTracker;
import org.apache.pulsar.broker.service.persistent.AbstractPersistentDispatcherMultipleConsumers;
import org.roaringbitmap.longlong.Roaring64Bitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDelayedDeliveryTracker
extends AbstractDelayedDeliveryTracker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryDelayedDeliveryTracker.class);
    protected final Long2ObjectSortedMap<Long2ObjectSortedMap<Roaring64Bitmap>> delayedMessageMap = new Long2ObjectAVLTreeMap();
    @VisibleForTesting
    private final long fixedDelayDetectionLookahead;
    private long highestDeliveryTimeTracked = 0L;
    private boolean messagesHaveFixedDelay = true;
    private final int timestampPrecisionBitCnt;
    private final AtomicLong delayedMessagesCount = new AtomicLong(0L);

    InMemoryDelayedDeliveryTracker(AbstractPersistentDispatcherMultipleConsumers dispatcher, Timer timer, long tickTimeMillis, boolean isDelayedDeliveryDeliverAtTimeStrict, long fixedDelayDetectionLookahead) {
        this(dispatcher, timer, tickTimeMillis, Clock.systemUTC(), isDelayedDeliveryDeliverAtTimeStrict, fixedDelayDetectionLookahead);
    }

    public InMemoryDelayedDeliveryTracker(AbstractPersistentDispatcherMultipleConsumers dispatcher, Timer timer, long tickTimeMillis, Clock clock, boolean isDelayedDeliveryDeliverAtTimeStrict, long fixedDelayDetectionLookahead) {
        super(dispatcher, timer, tickTimeMillis, clock, isDelayedDeliveryDeliverAtTimeStrict);
        this.fixedDelayDetectionLookahead = fixedDelayDetectionLookahead;
        this.timestampPrecisionBitCnt = InMemoryDelayedDeliveryTracker.calculateTimestampPrecisionBitCnt(tickTimeMillis);
    }

    private static int calculateTimestampPrecisionBitCnt(long tickTimeMillis) {
        int bitCnt = 0;
        while (tickTimeMillis > 0L) {
            tickTimeMillis >>= 1;
            ++bitCnt;
        }
        return bitCnt > 0 ? bitCnt - 1 : 0;
    }

    private static long trimLowerBit(long timestamp, int bits) {
        return timestamp & -1L << bits;
    }

    @Override
    public boolean addMessage(long ledgerId, long entryId, long deliverAt) {
        if (deliverAt < 0L || deliverAt <= this.getCutoffTime()) {
            this.messagesHaveFixedDelay = false;
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Add message {}:{} -- Delivery in {} ms ", new Object[]{this.dispatcher.getName(), ledgerId, entryId, deliverAt - this.clock.millis()});
        }
        long timestamp = InMemoryDelayedDeliveryTracker.trimLowerBit(deliverAt, this.timestampPrecisionBitCnt);
        ((Roaring64Bitmap)((Long2ObjectSortedMap)this.delayedMessageMap.computeIfAbsent(timestamp, k -> new Long2ObjectRBTreeMap())).computeIfAbsent(ledgerId, k -> new Roaring64Bitmap())).add(new long[]{entryId});
        this.delayedMessagesCount.incrementAndGet();
        this.updateTimer();
        this.checkAndUpdateHighest(deliverAt);
        return true;
    }

    private void checkAndUpdateHighest(long deliverAt) {
        if (deliverAt < this.highestDeliveryTimeTracked - this.tickTimeMillis) {
            this.messagesHaveFixedDelay = false;
        }
        this.highestDeliveryTimeTracked = Math.max(this.highestDeliveryTimeTracked, deliverAt);
    }

    @Override
    public boolean hasMessageAvailable() {
        boolean hasMessageAvailable;
        boolean bl = hasMessageAvailable = !this.delayedMessageMap.isEmpty() && this.delayedMessageMap.firstLongKey() <= this.getCutoffTime();
        if (!hasMessageAvailable) {
            this.updateTimer();
        }
        return hasMessageAvailable;
    }

    @Override
    public NavigableSet<Position> getScheduledMessages(int maxMessages) {
        long timestamp;
        int n = maxMessages;
        TreeSet<Position> positions = new TreeSet<Position>();
        long cutoffTime = this.getCutoffTime();
        while (n > 0 && !this.delayedMessageMap.isEmpty() && (timestamp = this.delayedMessageMap.firstLongKey()) <= cutoffTime) {
            LongOpenHashSet ledgerIdToDelete = new LongOpenHashSet();
            Long2ObjectSortedMap ledgerMap = (Long2ObjectSortedMap)this.delayedMessageMap.get(timestamp);
            for (Long2ObjectMap.Entry ledgerEntry : ledgerMap.long2ObjectEntrySet()) {
                long ledgerId = ledgerEntry.getLongKey();
                Roaring64Bitmap entryIds = (Roaring64Bitmap)ledgerEntry.getValue();
                int cardinality = (int)entryIds.getLongCardinality();
                if (cardinality <= n) {
                    entryIds.forEach(entryId -> positions.add(PositionFactory.create((long)ledgerId, (long)entryId)));
                    n -= cardinality;
                    this.delayedMessagesCount.addAndGet(-cardinality);
                    ledgerIdToDelete.add(ledgerId);
                } else {
                    long[] entryIdsArray = entryIds.toArray();
                    for (int i = 0; i < n; ++i) {
                        positions.add(PositionFactory.create((long)ledgerId, (long)entryIdsArray[i]));
                        entryIds.removeLong(entryIdsArray[i]);
                    }
                    this.delayedMessagesCount.addAndGet(-n);
                    n = 0;
                }
                if (n > 0) continue;
                break;
            }
            ObjectBidirectionalIterator objectBidirectionalIterator = ledgerIdToDelete.iterator();
            while (objectBidirectionalIterator.hasNext()) {
                long ledgerId = (Long)objectBidirectionalIterator.next();
                ledgerMap.remove(ledgerId);
            }
            if (!ledgerMap.isEmpty()) continue;
            this.delayedMessageMap.remove(timestamp);
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Get scheduled messages - found {}", (Object)this.dispatcher.getName(), (Object)positions.size());
        }
        if (this.delayedMessageMap.isEmpty()) {
            this.highestDeliveryTimeTracked = 0L;
            this.messagesHaveFixedDelay = true;
            if (this.delayedMessagesCount.get() != 0L) {
                log.warn("[{}] Delayed message tracker is empty, but delayedMessagesCount is {}", (Object)this.dispatcher.getName(), (Object)this.delayedMessagesCount.get());
            }
        }
        this.updateTimer();
        return positions;
    }

    @Override
    public CompletableFuture<Void> clear() {
        this.delayedMessageMap.clear();
        this.delayedMessagesCount.set(0L);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public long getNumberOfDelayedMessages() {
        return this.delayedMessagesCount.get();
    }

    @Override
    public long getBufferMemoryUsage() {
        return this.delayedMessageMap.values().stream().mapToLong(ledgerMap -> ledgerMap.values().stream().mapToLong(Roaring64Bitmap::getLongSizeInBytes).sum()).sum();
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public boolean shouldPauseAllDeliveries() {
        return this.fixedDelayDetectionLookahead > 0L && this.messagesHaveFixedDelay && this.getNumberOfDelayedMessages() >= this.fixedDelayDetectionLookahead && !this.hasMessageAvailable();
    }

    @Override
    protected long nextDeliveryTime() {
        return this.delayedMessageMap.firstLongKey();
    }

    @Generated
    public long getFixedDelayDetectionLookahead() {
        return this.fixedDelayDetectionLookahead;
    }
}

