/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.xds.CdsLoadBalancer2;
import java.util.Map;

@Internal
public class CdsLoadBalancerProvider
extends LoadBalancerProvider {
    private static final String CLUSTER_KEY = "cluster";

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "cds_experimental";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new CdsLoadBalancer2(helper);
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        return CdsLoadBalancerProvider.parseLoadBalancingConfigPolicy(rawLoadBalancingPolicyConfig);
    }

    static NameResolver.ConfigOrError parseLoadBalancingConfigPolicy(Map<String, ?> rawLoadBalancingPolicyConfig) {
        try {
            String cluster = JsonUtil.getString(rawLoadBalancingPolicyConfig, (String)CLUSTER_KEY);
            return NameResolver.ConfigOrError.fromConfig((Object)new CdsConfig(cluster));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withCause((Throwable)e).withDescription("Failed to parse CDS LB config: " + rawLoadBalancingPolicyConfig));
        }
    }

    static final class CdsConfig {
        final String name;

        CdsConfig(String name) {
            Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)"name is null or empty");
            this.name = name;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
        }
    }
}

