/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.StringTokenizer;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.io.ParseUtils;
import org.locationtech.spatial4j.io.ShapeReader;
import org.locationtech.spatial4j.io.WKTReader;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

@Deprecated
public class LegacyShapeReader
implements ShapeReader {
    final SpatialContext ctx;

    public LegacyShapeReader(SpatialContext ctx, SpatialContextFactory factory) {
        this.ctx = ctx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Shape readShapeOrNull(String str, SpatialContext ctx) throws InvalidShapeException {
        if (str == null || str.length() == 0) {
            throw new InvalidShapeException(str);
        }
        if (Character.isLetter(str.charAt(0))) {
            Point pt;
            int idx;
            if (!str.startsWith("Circle(") && !str.startsWith("CIRCLE(") || (idx = str.lastIndexOf(41)) <= 0) return null;
            String body2 = str.substring("Circle(".length(), idx);
            StringTokenizer st = new StringTokenizer(body2, " ");
            String token = st.nextToken();
            if (token.indexOf(44) != -1) {
                pt = LegacyShapeReader.readLatCommaLonPoint(token, ctx);
            } else {
                double x = Double.parseDouble(token);
                double y = Double.parseDouble(st.nextToken());
                pt = ctx.makePoint(x, y);
            }
            Double d = null;
            String arg = st.nextToken();
            idx = arg.indexOf(61);
            if (idx > 0) {
                String k = arg.substring(0, idx);
                if (!k.equals("d") && !k.equals("distance")) throw new InvalidShapeException("unknown arg: " + k + " :: " + str);
                d = Double.parseDouble(arg.substring(idx + 1));
            } else {
                d = Double.parseDouble(arg);
            }
            if (st.hasMoreTokens()) {
                throw new InvalidShapeException("Extra arguments: " + st.nextToken() + " :: " + str);
            }
            if (d != null) return ctx.makeCircle(pt, d);
            throw new InvalidShapeException("Missing Distance: " + str);
        }
        if (str.indexOf(44) != -1) {
            return LegacyShapeReader.readLatCommaLonPoint(str, ctx);
        }
        StringTokenizer st = new StringTokenizer(str, " ");
        double p0 = Double.parseDouble(st.nextToken());
        double p1 = Double.parseDouble(st.nextToken());
        if (!st.hasMoreTokens()) return ctx.makePoint(p0, p1);
        double p2 = Double.parseDouble(st.nextToken());
        double p3 = Double.parseDouble(st.nextToken());
        if (!st.hasMoreTokens()) return ctx.makeRectangle(p0, p2, p1, p3);
        throw new InvalidShapeException("Only 4 numbers supported (rect) but found more: " + str);
    }

    private static Point readLatCommaLonPoint(String value, SpatialContext ctx) throws InvalidShapeException {
        double[] latLon = ParseUtils.parseLatitudeLongitude(value);
        return ctx.makePoint(latLon[1], latLon[0]);
    }

    @Override
    public String getFormatName() {
        return "LEGACY";
    }

    @Override
    public Shape read(Object value) throws IOException, ParseException, InvalidShapeException {
        Shape shape = LegacyShapeReader.readShapeOrNull(value.toString(), this.ctx);
        if (shape == null) {
            throw new ParseException("unable to read shape: " + value, 0);
        }
        return LegacyShapeReader.readShapeOrNull(value.toString(), this.ctx);
    }

    @Override
    public Shape readIfSupported(Object value) throws InvalidShapeException {
        return LegacyShapeReader.readShapeOrNull(value.toString(), this.ctx);
    }

    @Override
    public Shape read(Reader reader) throws IOException, ParseException, InvalidShapeException {
        return this.read(WKTReader.readString(reader));
    }
}

