/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp.debug;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.twak.camp.Edge;
import org.twak.camp.Machine;
import org.twak.camp.Output;
import org.twak.camp.Skeleton;
import org.twak.camp.debug.DebugDevice;
import org.twak.camp.ui.Bar;
import org.twak.camp.ui.PointEditor;
import org.twak.utils.LContext;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.Loopable;

public class SkeletonPointEditor
extends PointEditor {
    boolean changed = true;
    boolean busy = false;
    Output output;

    public SkeletonPointEditor() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void movePoint(LContext<Bar> ctx, Point2d pt, Point2d location, MouseEvent evt) {
        this.changed = true;
        super.movePoint(ctx, pt, location, evt);
    }

    @Override
    public void remove(LContext<Bar> ctx, Point2d dragged) {
        this.changed = true;
        super.remove(ctx, dragged);
    }

    @Override
    public void addBetween(LContext<Bar> ctx, Point l) {
        this.changed = true;
        super.addBetween(ctx, l);
    }

    @Override
    public void paintPointEditor(Graphics2D g2) {
        g2.setColor(Color.red);
        Polygon border = new Polygon();
        for (Loop loop : this.edges) {
            for (Bar bar : loop) {
                border.addPoint(this.ma.toX(bar.start.x), this.ma.toY(bar.start.y));
            }
        }
        final LoopL out = new LoopL();
        Machine machine = new Machine(0.7853981633974483);
        for (Loop lb : this.edges) {
            Loop<Edge> loop = new Loop<Edge>();
            out.add(loop);
            for (Bar bar : lb) {
                Edge e = new Edge(new Point3d(bar.start.x, bar.start.y, 0.0), new Point3d(bar.end.x, bar.end.y, 0.0), 0.7853981633974483);
                e.machine = machine;
                loop.append(e);
            }
            for (Loopable loopable : loop.loopableIterator()) {
                ((Edge)loopable.get()).end = ((Edge)loopable.getNext().get()).start;
            }
        }
        if (!this.busy && this.changed) {
            this.busy = true;
            this.changed = false;
            new Thread(){

                @Override
                public void run() {
                    try {
                        DebugDevice.reset();
                        Skeleton skeleton = new Skeleton((LoopL<Edge>)out, true);
                        skeleton.skeleton();
                        SkeletonPointEditor.this.output = skeleton.output;
                    }
                    finally {
                        SkeletonPointEditor.this.busy = false;
                        SkeletonPointEditor.this.repaint();
                    }
                }
            }.start();
        }
        this.paintMultiColourOutput(g2);
        g2.setColor(new Color(0, 168, 40));
        g2.draw(border);
    }

    public void paintMultiColourOutput(Graphics2D g2) {
        if (this.output != null && this.output.faces != null) {
            int faceCount = this.output.faces.size();
            g2.setStroke(new BasicStroke(1.0f));
            int faceIndex = 0;
            for (Output.Face face : this.output.faces.values()) {
                LoopL<Point3d> loopl = face.getLoopL();
                int loopIndex = 0;
                ++faceIndex;
                for (Loop loop : loopl) {
                    Polygon pg = new Polygon();
                    for (Point3d p : loop) {
                        pg.addPoint(this.ma.toX(p.x), this.ma.toY(p.y));
                    }
                    if (pg.npoints > 2) {
                        if (loopIndex == 0) {
                            g2.setColor(new Color(168, 212, 126));
                        } else {
                            g2.setColor(Color.white);
                        }
                        g2.fillPolygon(pg);
                        g2.setColor(new Color(33, 108, 229));
                        g2.drawPolygon(pg);
                    }
                    ++loopIndex;
                }
            }
        }
    }
}

