/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;
import org.twak.utils.Cache;
import org.twak.utils.Filez;
import org.twak.utils.Mathz;
import org.twak.utils.geom.DRectangle;

public class Imagez {
    private static Cache<Integer, float[][]> gaussian = new Cache<Integer, float[][]>(){

        @Override
        public float[][] create(Integer radius) {
            int i;
            int size = radius * 2 + 1;
            float[] data = new float[size];
            float sigma = (float)radius.intValue() / 3.0f;
            float twoSigmaSquare = 2.0f * sigma * sigma;
            float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
            float total = 0.0f;
            for (i = -radius.intValue(); i <= radius; ++i) {
                float distance = i * i;
                int index = i + radius;
                data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
                total += data[index];
            }
            i = 0;
            while (i < data.length) {
                int n = i++;
                data[n] = data[n] / total;
            }
            float[][] d2 = new float[size][size];
            for (int x = 0; x < data.length; ++x) {
                for (int y = 0; y < data.length; ++y) {
                    d2[x][y] = data[x] * data[y];
                }
            }
            return d2;
        }
    };
    static Random randy = new Random();

    public static void writeSummary(File file, List<BufferedImage> images) {
        int width = 0;
        int height = 0;
        for (BufferedImage vi : images) {
            width = Math.max(width, vi.getWidth());
            height += vi.getHeight();
        }
        if (width == 0 || height == 0) {
            return;
        }
        BufferedImage out = new BufferedImage(width, height, 5);
        Graphics2D g2 = out.createGraphics();
        int y = 0;
        for (BufferedImage vi : images) {
            g2.drawImage(vi, (width - vi.getWidth()) / 2, y, vi.getWidth(), vi.getHeight(), null);
            y += vi.getHeight();
        }
        try {
            ImageIO.write((RenderedImage)out, Filez.getExtn(file.getName()), file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeJPG(BufferedImage rendered, float quality, File f) {
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        try {
            JPEGImageWriteParam jpegParams = new JPEGImageWriteParam(null);
            jpegParams.setCompressionMode(2);
            jpegParams.setCompressionQuality(quality);
            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(quality);
            writer.setOutput(new FileImageOutputStream(f));
            writer.write(null, new IIOImage(rendered, null, null), jpegParams);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    private static void toComp(int c, double[] t2, double scale) {
        t2[0] = t2[0] + (double)(c >> 16 & 0xFF) * scale;
        t2[1] = t2[1] + (double)(c >> 8 & 0xFF) * scale;
        t2[2] = t2[2] + (double)(c & 0xFF) * scale;
    }

    private static void toComp(int c, double[] t2) {
        t2[0] = c >> 16 & 0xFF;
        t2[1] = c >> 8 & 0xFF;
        t2[2] = c & 0xFF;
    }

    public static int fromComp(double[] t2) {
        return -16777216 + ((int)t2[0] << 16) + ((int)t2[1] << 8) + (int)t2[2];
    }

    public static int fromComp(double r, double g2, double b) {
        return -16777216 + ((int)r << 16) + ((int)g2 << 8) + (int)b;
    }

    public static int fromComp(int[] t2) {
        return -16777216 + (t2[0] << 16) + (t2[1] << 8) + t2[2];
    }

    public static BufferedImage blur(int radius, BufferedImage in) {
        if (radius < 1) {
            return in;
        }
        int size = radius * 2 + 1;
        float[][] filter = gaussian.get(radius);
        double[] accm = new double[4];
        BufferedImage out = new BufferedImage(in.getWidth(), in.getHeight(), 5);
        for (int xs = 0; xs < in.getWidth(); ++xs) {
            for (int ys = 0; ys < in.getHeight(); ++ys) {
                Arrays.fill(accm, 0.0);
                for (int xf = 0; xf < size; ++xf) {
                    for (int yf = 0; yf < size; ++yf) {
                        int px = Mathz.clamp(xs + xf - radius, 0, in.getWidth() - 1);
                        int py = Mathz.clamp(ys + yf - radius, 0, in.getHeight() - 1);
                        Imagez.toComp(in.getRGB(px, py), accm, filter[xf][yf]);
                    }
                }
                out.setRGB(xs, ys, -16777216 + ((int)accm[0] << 16) + ((int)accm[1] << 8) + ((int)accm[2] << 0));
            }
        }
        return out;
    }

    public static BufferedImage scaleLongest(BufferedImage in, int longest) {
        double scale = in.getWidth() > in.getHeight() ? (double)longest / (double)in.getWidth() : (double)longest / (double)in.getHeight();
        BufferedImage out = new BufferedImage((int)((double)in.getWidth() * scale), (int)((double)in.getHeight() * scale), 5);
        Graphics2D g2 = out.createGraphics();
        Image sm = in.getScaledInstance(out.getWidth(), out.getHeight(), 4);
        g2.drawImage(sm, 0, 0, null);
        g2.dispose();
        return out;
    }

    public static BufferedImage scaleSquare(BufferedImage in, int s2) {
        return Imagez.scaleSquare(in, s2, null, Double.MAX_VALUE, Color.black, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    public static BufferedImage scaleSquare(BufferedImage in, int s2, double maxScale) {
        return Imagez.scaleSquare(in, s2, null, maxScale, Color.black, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    public static BufferedImage scaleSquare(BufferedImage in, int s2, DRectangle pixeLocation, double maxScale, Color bg, Object quality) {
        double scale = in.getWidth() > in.getHeight() ? (double)s2 / (double)in.getWidth() : (double)s2 / (double)in.getHeight();
        scale = Math.min(maxScale, scale);
        int ypad = (int)((double)s2 - (double)in.getHeight() * scale) / 2;
        int xpad = (int)((double)s2 - (double)in.getWidth() * scale) / 2;
        int nx = (int)((double)xpad + (double)in.getWidth() * scale);
        int ny = (int)((double)ypad + (double)in.getHeight() * scale);
        BufferedImage out = new BufferedImage(s2, s2, 5);
        Graphics2D g2 = out.createGraphics();
        g2.setColor(bg);
        g2.fillRect(0, 0, s2, s2);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, quality);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.drawImage(in, xpad, ypad, nx, ny, 0, 0, in.getWidth(), in.getHeight(), null);
        g2.dispose();
        if (pixeLocation != null) {
            pixeLocation.x = xpad;
            pixeLocation.y = ypad;
            pixeLocation.width = nx - xpad;
            pixeLocation.height = ny - ypad;
        }
        return out;
    }

    public static BufferedImage join(BufferedImage a, BufferedImage b) {
        BufferedImage both = new BufferedImage(a.getWidth() + b.getWidth(), a.getHeight(), 5);
        Graphics2D g2 = (Graphics2D)both.getGraphics();
        g2.drawImage(a, 0, 0, a.getWidth(), a.getHeight(), 0, 0, a.getWidth(), a.getHeight(), null);
        g2.drawImage(b, a.getWidth(), 0, a.getWidth() + b.getWidth(), b.getHeight(), 0, 0, b.getWidth(), b.getHeight(), null);
        g2.dispose();
        return both;
    }

    public static BufferedImage scaleTo(BufferedImage bi, int x, int y) {
        BufferedImage out = new BufferedImage(x, y, 5);
        Graphics2D g2 = out.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.drawImage(bi, 0, 0, x, y, 0, 0, bi.getWidth(), bi.getHeight(), null);
        g2.dispose();
        return out;
    }

    public static void gaussianNoise(BufferedImage b, double scale) {
        double[] tmp = new double[3];
        for (int x = 0; x < b.getWidth(); ++x) {
            for (int y = 0; y < b.getHeight(); ++y) {
                Imagez.toComp(b.getRGB(x, y), tmp);
                for (int i = 0; i < tmp.length; ++i) {
                    tmp[i] = Mathz.clamp(tmp[i] + randy.nextGaussian() * 255.0 * scale, 0.0, 255.0);
                }
                b.setRGB(x, y, Imagez.fromComp(tmp));
            }
        }
    }

    public static BufferedImage padTo(BufferedImage in, DRectangle mask, int x, int y, Color bg) {
        if (in.getWidth() > x || in.getHeight() > y) {
            throw new Error();
        }
        BufferedImage out = new BufferedImage(x, y, in.getType());
        Graphics2D g2 = out.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int xd = (x - in.getWidth()) / 2;
        int yd = (y - in.getHeight()) / 2;
        g2.setColor(bg);
        g2.fillRect(0, 0, x, y);
        g2.drawImage(in, xd, yd, in.getWidth(), in.getHeight(), null);
        g2.dispose();
        if (mask != null) {
            mask.x += (double)xd;
            mask.y += (double)yd;
        }
        return out;
    }

    public static BufferedImage cropShared(BufferedImage src, DRectangle w) {
        return src.getSubimage((int)w.x, (int)w.y, (int)w.width, (int)w.height);
    }

    public static BufferedImage clone(BufferedImage source) {
        BufferedImage b = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        Graphics2D g2 = b.createGraphics();
        g2.drawImage((Image)source, 0, 0, null);
        g2.dispose();
        return b;
    }

    public static BufferedImage read(File f) {
        try {
            return ImageIO.read(f);
        }
        catch (Throwable th) {
            return new BufferedImage(1, 1, 5);
        }
    }

    public static void fill(BufferedImage roomcat, Color color) {
        Graphics2D g2 = roomcat.createGraphics();
        g2.setColor(color);
        g2.fillRect(0, 0, roomcat.getWidth(), roomcat.getHeight());
        g2.dispose();
    }
}

