/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Point2d;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.twak.utils.PaintThing;
import org.twak.utils.PanMouseAdaptor;
import org.twak.utils.WeakListener;
import org.twak.utils.geom.DRectangle;
import org.twak.utils.ui.ListDownLayout;
import org.twak.utils.ui.Rainbow;
import org.twak.utils.ui.WindowManager;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class Plot
extends JComponent {
    public PanMouseAdaptor ma;
    String text = "";
    public List<Object> toPaint = new ArrayList<Object>();
    boolean firstFrame = true;
    public JFrame open = null;
    JPanel controls;
    static Plot last;
    List<WeakListener.Changed> onChange = new ArrayList<WeakListener.Changed>();
    ICanEdit clickedOn = null;

    public void publicPaintComponent(Graphics g2) {
        this.paintComponent(g2);
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        g22.setColor(Color.white);
        g22.fillRect(0, 0, this.getWidth(), this.getHeight());
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g22.setColor(new Color(0, 0, 0, 10));
        this.paint(this.toPaint, g22);
        DRectangle bounds = PaintThing.getBounds();
        if (this.firstFrame) {
            if (bounds != null) {
                this.ma.view(bounds);
            } else {
                this.ma.resetView();
            }
        }
        this.firstFrame = false;
        PaintThing.resetBounds();
    }

    private void paint(Iterable<Object> p, Graphics2D g2) {
        int count = 4;
        for (Object o : p) {
            g2.setColor(Rainbow.getColour(count++));
            PaintThing.paint(o, g2, this.ma);
        }
        g2.setColor(Color.black);
        PaintThing.paintDebug(g2, this.ma);
        g2.drawString(this.text, 20, this.getHeight() - 30);
    }

    public Plot(Object ... o) {
        this();
        ArrayList<Object> lo = new ArrayList<Object>(Arrays.asList(o));
        JFrame frame = new JFrame("plot");
        WindowManager.register(frame);
        if (last != null) {
            this.ma.resetView(Plot.last.ma);
        }
        frame.setLayout(new BorderLayout());
        frame.add((Component)this, "Center");
        this.controls = new JPanel(new ListDownLayout());
        Iterator io = lo.iterator();
        while (io.hasNext()) {
            Object oa = io.next();
            if (!(oa instanceof JComponent)) continue;
            this.controls.add((JComponent)oa);
            io.remove();
        }
        if (this.controls.getComponentCount() > 0) {
            frame.add((Component)this.controls, "East");
        }
        frame.pack();
        frame.setVisible(true);
        if (this.open != null) {
            try {
                frame.setLocation(this.open.getLocationOnScreen());
                frame.setSize(this.open.getSize());
                Plot.closeLast();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        last = this;
        this.open = frame;
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 83) {
                    Plot.this.dumpSVG();
                }
            }
        });
        this.toPaint.addAll(lo);
    }

    public static void closeLast() {
        if (last != null) {
            last.close();
        }
    }

    public void close() {
        if (this.open != null) {
            this.open.setVisible(false);
            this.open.dispose();
            this.open = null;
        }
    }

    public Plot add(Object o) {
        if (o instanceof JComponent) {
            this.controls.add((JComponent)o);
            this.controls.revalidate();
        } else {
            this.toPaint.add(o);
            this.repaint();
        }
        return this;
    }

    private void dumpSVG() {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        this.paintComponent(svgGenerator);
        try {
            svgGenerator.stream(new FileWriter("/home/twak/Desktop/dump.svg"), true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void addEditListener(WeakListener.Changed changed) {
        this.onChange.add(changed);
    }

    public Plot() {
        this.ma = new PanMouseAdaptor(this);
        this.ma.button = 1;
        this.setPreferredSize(new Dimension(600, 600));
        MouseAdapter m3 = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Plot.this.setText(String.valueOf(Plot.this.ma.from(e)));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ICanEdit bestEdit = null;
                double bestDist = Double.MAX_VALUE;
                Plot.this.clickedOn = null;
                for (Object o : Plot.this.toPaint) {
                    double dist;
                    if (o == null) continue;
                    ICanEdit ice = o instanceof ICanEdit ? (ICanEdit)o : null;
                    Class c = null;
                    if (ice == null && null != (c = PaintThing.editLookup.get(o.getClass()))) {
                        try {
                            ice = (ICanEdit)c.newInstance();
                        }
                        catch (Throwable e1) {
                            e1.printStackTrace();
                        }
                        ice.setObject(o);
                    }
                    if (ice == null || !((dist = (double)Plot.this.ma.toZoom(ice.getDistance(Plot.this.ma.from(e)))) < bestDist)) continue;
                    bestDist = dist;
                    bestEdit = ice;
                }
                if (e.getButton() == 3) {
                    Plot.this.clickedOn = bestEdit;
                    if (Plot.this.clickedOn != null) {
                        Plot.this.clickedOn.mouseDown(e, Plot.this.ma);
                    }
                    Plot.this.repaint();
                } else if (e.getButton() == 2 && bestEdit != null) {
                    bestEdit.getMenu(e, Plot.this.ma, new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            Plot.this.repaint();
                            for (WeakListener.Changed c : Plot.this.onChange) {
                                c.changed();
                            }
                        }
                    });
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Plot.this.clickedOn != null) {
                    Plot.this.clickedOn.mouseDragged(e, Plot.this.ma);
                }
                Plot.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (Plot.this.clickedOn != null) {
                    Plot.this.clickedOn.mouseReleased(e, Plot.this.ma);
                    Plot.this.repaint();
                    if (e.getButton() == 3) {
                        for (WeakListener.Changed c : Plot.this.onChange) {
                            c.changed();
                        }
                    }
                }
                Plot.this.clickedOn = null;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Plot.this.setText("");
            }
        };
        this.addMouseListener(m3);
        this.addMouseMotionListener(m3);
    }

    protected void setText(String string) {
        if (this.text != string) {
            this.text = string;
            this.repaint();
        }
    }

    public void writeImage(String string) {
        BufferedImage out = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        this.paintComponent(out.getGraphics());
        try {
            ImageIO.write((RenderedImage)out, "png", new File(string + ".png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static interface ICanEdit {
        public void setObject(Object var1);

        public double getDistance(Point2d var1);

        public void mouseDown(MouseEvent var1, PanMouseAdaptor var2);

        public void mouseDragged(MouseEvent var1, PanMouseAdaptor var2);

        public void mouseReleased(MouseEvent var1, PanMouseAdaptor var2);

        public void getMenu(MouseEvent var1, PanMouseAdaptor var2, ChangeListener var3);
    }

    public static class Origin
    implements PaintThing.ICanPaint {
        @Override
        public void paint(Graphics2D g2, PanMouseAdaptor ma) {
            g2.setColor(Color.black);
            int big = 10000;
            g2.drawLine(ma.toX(0.0), 0, ma.toX(0.0), big);
            g2.drawLine(0, ma.toY(0.0), big, ma.toY(0.0));
        }
    }
}

