/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;
import org.twak.utils.ui.SimpleFileChooser;

public class FileDrop
extends JLabel {
    public FileDrop(String label) {
        super(label);
        this.setPreferredSize(new Dimension(200, 80));
        this.setHorizontalAlignment(0);
        this.setBorder(new LineBorder(Color.black, 3));
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                FileDrop.this.setBackground(Color.gray);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                FileDrop.this.setBackground(Color.white);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                FileDrop.this.setBackground(Color.gray);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                new SimpleFileChooser(null, false, "select image file, or drag n drop"){

                    @Override
                    public void heresTheFile(File f) throws Throwable {
                        FileDrop.this.process(f);
                    }
                };
                super.mouseClicked(e);
            }
        };
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
        this.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                try {
                    evt.acceptDrop(1);
                    final List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    new Thread(){

                        @Override
                        public void run() {
                            for (File file : droppedFiles) {
                                FileDrop.this.process(file);
                            }
                        }
                    }.start();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void process(File f) {
    }
}

