/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import javax.vecmath.Point2d;
import org.twak.utils.Line;
import org.twak.utils.collections.ItComb;

public class Intersector {
    PriorityQueue<Event> events;
    TreeSet<Line> beachline = new TreeSet<Line>(new XOrderLineComparator());
    List<Collision> output = new ArrayList<Collision>();
    Point2d processing;
    static final int START = 1;
    static final int END = 2;
    static final int INTERSECT = 4;
    static PointComparator pointComparator = new PointComparator();
    static int index_ = 0;

    public List<Collision> intersectLines(Iterable<Line> a) {
        index_ = 0;
        this.events = new PriorityQueue();
        for (Line orig : a) {
            ILine iL = new ILine(orig);
            Event sE = new Event(iL.start, 1);
            sE.a = iL;
            this.events.add(sE);
            Event eE = new Event(iL.end, 2);
            eE.a = iL;
            this.events.add(eE);
        }
        while (this.events.size() > 0) {
            Event e;
            HashSet<Event> starts = new HashSet<Event>();
            HashSet<Event> ends = new HashSet<Event>();
            HashSet<Event> intersects = new HashSet<Event>();
            Event f = e = this.events.peek();
            while (e.location.equals(f.location)) {
                Event toAdd = this.events.poll();
                switch (toAdd.type) {
                    case 4: {
                        intersects.add(toAdd);
                        break;
                    }
                    case 1: {
                        starts.add(toAdd);
                        break;
                    }
                    case 2: {
                        ends.add(toAdd);
                    }
                }
                if ((f = this.events.peek()) != null) continue;
                break;
            }
            this.process(starts, ends, intersects, e.location);
        }
        return this.output;
    }

    private void collide(Line a, Line b) {
        Point2d collide = a.intersects(b);
        if (collide == null) {
            return;
        }
        for (Line l : new Line[]{a, b}) {
            if (l.isHoriz()) {
                collide.y = l.start.y;
            }
            if (!l.isVert()) continue;
            collide.x = l.start.x;
        }
        if (a.start.equals(b.end) || a.start.equals(b.start)) {
            collide = a.start;
        }
        if (a.end.equals(b.end) || a.end.equals(b.start)) {
            collide = a.end;
        }
        if (collide.y < this.processing.y || collide.y == this.processing.y && collide.x <= this.processing.x) {
            return;
        }
        Event e = new Event(collide, 4);
        e.a = a;
        e.b = b;
        this.events.add(e);
    }

    private void process(Set<Event> starts, Set<Event> ends, Set<Event> intersects, Point2d location) {
        Event sample;
        Event event = starts.size() > 0 ? starts.iterator().next() : (sample = ends.size() > 0 ? ends.iterator().next() : intersects.iterator().next());
        if (intersects.size() > 0 || starts.size() + ends.size() > 1) {
            LinkedHashSet<Line> lines = new LinkedHashSet<Line>();
            for (Event e : new ItComb<Event>(starts, ends)) {
                lines.add(((ILine)e.a).orig);
            }
            for (Event e : intersects) {
                lines.add(((ILine)e.a).orig);
                lines.add(((ILine)e.b).orig);
            }
            Collision c = new Collision(sample.location, new ArrayList<Line>(lines));
            this.output.add(c);
        }
        HashSet<Line> ending = new HashSet<Line>();
        for (Event e : ends) {
            ending.add(e.a);
        }
        for (Event e : new ItComb<Event>(ends, intersects)) {
            boolean removed = this.beachline.remove(e.a);
            if (e.b == null) continue;
            removed = this.beachline.remove(e.b);
        }
        this.processing = location;
        Line nextLine = this.beachline.higher(sample.a);
        Line prevLine = this.beachline.lower(sample.a);
        for (Event event2 : new ItComb<Event>(starts, intersects)) {
            if (!ending.contains(event2.a)) {
                this.beachline.add(event2.a);
            }
            if (event2.b == null || ending.contains(event2.b)) continue;
            this.beachline.add(event2.b);
        }
        HashSet<Line> processed = new HashSet<Line>();
        for (Event e : intersects) {
            processed.add(e.a);
            processed.add(e.b);
        }
        for (Event e : ends) {
            processed.remove(e.a);
        }
        for (Event e : starts) {
            processed.add(e.a);
        }
        if (processed.size() == 0) {
            if (prevLine != null && nextLine != null) {
                this.collide(prevLine, nextLine);
            }
        } else {
            ArrayList arrayList = new ArrayList(processed);
            Collections.sort(arrayList, new XOrderLineComparator());
            HashSet<Line> horiz = new HashSet<Line>();
            for (Line l : arrayList) {
                if (!l.isHoriz()) continue;
                horiz.add(l);
            }
            if (nextLine != null) {
                Line h2 = (Line)arrayList.get(arrayList.size() - 1);
                if (!horiz.isEmpty()) {
                    for (Line l : horiz) {
                        this.collide(l, nextLine);
                    }
                } else {
                    this.collide(h2, nextLine);
                }
            }
            if (prevLine != null) {
                Line l = (Line)arrayList.get(0);
                this.collide(l, prevLine);
            }
        }
    }

    private void dumpBeach() {
        System.out.print(String.valueOf(this.processing) + ":  ");
        for (Line l : this.beachline) {
            System.out.print(String.valueOf(l) + "[" + l.xAtY(this.processing.y) + "]:: ");
        }
        System.out.println();
    }

    public static void main(String[] args) {
        int count = 100;
        Random randy = new Random();
        while (true) {
            count += 100;
            ArrayList<Line> list = new ArrayList<Line>();
            for (int i = 0; i < count; ++i) {
                list.add(new Line(new Point2d(randy.nextInt(600), randy.nextInt(600)), new Point2d(randy.nextInt(600), randy.nextInt(600))));
            }
            long t = System.currentTimeMillis();
            Intersector i = new Intersector();
            i.intersectLines(list);
            System.out.printf("%d, %d \n", count, System.currentTimeMillis() - t);
        }
    }

    static class ILine
    extends Line {
        Line orig;

        public ILine(Line l) {
            if (pointComparator.compare(l.start, l.end) > 0) {
                this.start = l.end;
                this.end = l.start;
            } else {
                this.start = l.start;
                this.end = l.end;
            }
            this.orig = l;
        }
    }

    public static class Collision {
        public Point2d location;
        public List<Line> lines;

        public Collision(Point2d loc, List<Line> lines) {
            this.location = loc;
            this.lines = lines;
        }
    }

    private class XOrderLineComparator
    implements Comparator<Line> {
        private XOrderLineComparator() {
        }

        @Override
        public int compare(Line o1, Line o2) {
            Line horiz = null;
            Line notHoriz = null;
            int factor = 1;
            if (o1.equals(o2)) {
                return 0;
            }
            if (o1.isHoriz() && o2.isHoriz()) {
                if (o1.start.y == o2.start.y) {
                    return o1.hashCode() - o2.hashCode();
                }
                return Double.compare(o1.start.y, o1.end.y);
            }
            if (o1.isHoriz()) {
                horiz = o1;
                notHoriz = o2;
                factor = 1;
            } else if (o2.isHoriz()) {
                horiz = o2;
                notHoriz = o1;
                factor = -1;
            }
            if (horiz != null) {
                double x = notHoriz.xAtY(Intersector.this.processing.y);
                if (notHoriz.isVert()) {
                    x = notHoriz.start.x;
                }
                if (Intersector.this.processing.equals(notHoriz.start)) {
                    x = notHoriz.start.x;
                }
                if (Intersector.this.processing.equals(notHoriz.end)) {
                    x = notHoriz.end.x;
                }
                if (x <= horiz.start.x) {
                    return 1 * factor;
                }
                if (x >= horiz.end.x) {
                    return -1 * factor;
                }
                if (Intersector.this.processing.x < x) {
                    return -1 * factor;
                }
                if (Intersector.this.processing.x > x) {
                    return 1 * factor;
                }
                return factor;
            }
            double height = Intersector.this.processing.y + 1.0E-4;
            double h1 = o1.xAtY(height);
            double h2 = o2.xAtY(height);
            if (o1.isVert()) {
                h1 = o1.start.x;
            }
            if (o2.isVert()) {
                h2 = o2.start.x;
            }
            if (h1 == h2) {
                return o1.hashCode() - o2.hashCode();
            }
            return Double.compare(h1, h2);
        }
    }

    private class Event
    implements Comparable<Event> {
        Point2d location = new Point2d(Double.MAX_VALUE, Double.MAX_VALUE);
        int type = 0;
        Line a;
        Line b;

        public Event(Point2d location, int type) {
            this.location = location;
            this.type = type;
        }

        @Override
        public int compareTo(Event o) {
            return pointComparator.compare(this.location, o.location);
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "start " + String.valueOf(this.location);
                }
                case 2: {
                    return "end   " + String.valueOf(this.location);
                }
                case 4: {
                    return "inter " + String.valueOf(this.location);
                }
            }
            return "invalid type in Event!";
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.location != null ? this.location.hashCode() : 0);
            hash = 29 * hash + this.type;
            hash = 29 * hash + (this.a != null ? this.a.hashCode() : 0) + (this.b != null ? this.b.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Event other = (Event)obj;
            if (!this.location.equals(other.location)) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            if (this.b != null) {
                if (this.a.equals(other.a)) {
                    return this.b.equals(other.b);
                }
                if (this.b.equals(other.a)) {
                    return this.a.equals(other.b);
                }
            } else if (!this.a.equals(other.a)) {
                return false;
            }
            return true;
        }
    }

    private static class PointComparator
    implements Comparator<Point2d> {
        private PointComparator() {
        }

        @Override
        public int compare(Point2d o1, Point2d o2) {
            double r = o1.y - o2.y;
            if (r < 0.0) {
                return -1;
            }
            if (r > 0.0) {
                return 1;
            }
            r = o1.x - o2.x;
            if (r < 0.0) {
                return -1;
            }
            if (r > 0.0) {
                return 1;
            }
            return 0;
        }
    }
}

