/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.bootup;

import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.bootup.BootUpInformationCollector;
import org.apache.servicecomb.core.bootup.ConfigurationProblemsAlarmEvent;
import org.apache.servicecomb.foundation.common.event.AlarmEvent;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.springframework.core.env.Environment;

public class ConfigurationProblemsCollector
implements BootUpInformationCollector {
    private static final String SERVICE_NAME_PATTERN_STRING = "([A-Za-z])|([A-Za-z][A-Za-z0-9_\\-.]*[A-Za-z0-9])";
    private static final Pattern SERVICE_NAME_PATTERN = Pattern.compile("([A-Za-z])|([A-Za-z][A-Za-z0-9_\\-.]*[A-Za-z0-9])");

    @Override
    public String collect(SCBEngine engine) {
        if (engine.getEnvironment() == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        this.collectCsePrefix(engine.getEnvironment(), result);
        this.collectServiceDefinition(engine.getEnvironment(), result);
        this.collectServiceDefinitionValidation(result);
        this.collectTimeoutConfiguration(engine.getEnvironment(), result);
        this.collectIsolationConfiguration(engine.getEnvironment(), result);
        if (result.length() <= 0) {
            return null;
        }
        String warnings = "[WARN]Configurations warnings:\n" + result;
        EventManager.post((Object)((Object)new ConfigurationProblemsAlarmEvent(AlarmEvent.Type.OPEN, warnings)));
        return warnings;
    }

    private void collectServiceDefinitionValidation(StringBuilder result) {
        String serviceName;
        String application = BootStrapProperties.readApplication();
        if (!SERVICE_NAME_PATTERN.matcher(application).matches()) {
            result.append("application does not match pattern ").append(SERVICE_NAME_PATTERN_STRING).append(".");
        }
        if (!SERVICE_NAME_PATTERN.matcher(serviceName = BootStrapProperties.readServiceName()).matches()) {
            result.append("service name does not match pattern ").append(SERVICE_NAME_PATTERN_STRING).append(".");
        }
    }

    private void collectIsolationConfiguration(Environment environment, StringBuilder result) {
        int percentage = (Integer)environment.getProperty("servicecomb.loadbalance.isolation.errorThresholdPercentage", Integer.TYPE, (Object)-1);
        int continuous = (Integer)environment.getProperty("servicecomb.loadbalance.isolation.continuousFailureThreshold", Integer.TYPE, (Object)-1);
        if (percentage == -1 && continuous == -1) {
            return;
        }
        Boolean enable = (Boolean)environment.getProperty("servicecomb.loadbalance.filter.isolation.enabled", Boolean.class);
        if (enable != null) {
            return;
        }
        result.append("Configuration `servicecomb.loadbalance.isolation.*` is deprecated and disabled by default, use governance instead. See https://servicecomb.apache.org/references/java-chassis/zh_CN/references-handlers/governance-best-practise.html. If you want to enable it, add`servicecomb.loadbalance.filter.isolation.enabled=true` implicitly.");
    }

    private void collectTimeoutConfiguration(Environment environment, StringBuilder result) {
        int idleTimeoutInSeconds;
        int keepAliveTimeoutInSeconds = (Integer)environment.getProperty("servicecomb.rest.client.connection.keepAliveTimeoutInSeconds", Integer.TYPE, (Object)60);
        if (keepAliveTimeoutInSeconds >= (idleTimeoutInSeconds = ((Integer)environment.getProperty("servicecomb.rest.client.connection.idleTimeoutInSeconds", Integer.TYPE, (Object)150)).intValue())) {
            result.append("Configuration `servicecomb.rest.client.connection.keepAliveTimeoutInSeconds` is longer than servicecomb.rest.client.connection.idleTimeoutInSeconds.");
            result.append("[").append(keepAliveTimeoutInSeconds).append(",").append(idleTimeoutInSeconds).append("]\n");
        }
        if ((keepAliveTimeoutInSeconds = ((Integer)environment.getProperty("servicecomb.rest.client.http2.connection.keepAliveTimeoutInSeconds", Integer.TYPE, (Object)60)).intValue()) >= (idleTimeoutInSeconds = ((Integer)environment.getProperty("servicecomb.rest.client.http2.connection.idleTimeoutInSeconds", Integer.TYPE, (Object)150)).intValue())) {
            result.append("Configuration `servicecomb.rest.client.http2.connection.keepAliveTimeoutInSeconds` is longer than servicecomb.rest.client.http2.connection.idleTimeoutInSeconds.");
            result.append("[").append(keepAliveTimeoutInSeconds).append(",").append(idleTimeoutInSeconds).append("]\n");
        }
    }

    private void collectServiceDefinition(Environment environment, StringBuilder result) {
        Set names;
        if (environment.getProperty("APPLICATION_ID") != null) {
            result.append("Configurations `APPLICATION_ID` is deprecated, use `servicecomb.service.application` instead.\n");
        }
        if (!(names = ConfigUtil.propertiesWithPrefix((Environment)environment, (String)"service_description.")).isEmpty()) {
            result.append("Configurations with prefix `service_description` is deprecated, use `servicecomb.service` instead. Find keys ");
            result.append(Arrays.toString(names.toArray()));
            result.append("\n");
        }
    }

    private void collectCsePrefix(Environment environment, StringBuilder result) {
        Set names = ConfigUtil.propertiesWithPrefix((Environment)environment, (String)"cse.");
        if (!names.isEmpty()) {
            result.append("Configurations with prefix `cse` is deprecated, use `servicecomb` instead. Find keys ");
            result.append(Arrays.toString(names.toArray()));
            result.append("\n");
        }
    }

    @Override
    public String collect() {
        return null;
    }

    @Override
    public int getOrder() {
        return 1000;
    }
}

