/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.shardingsphere.elasticjob.kernel.internal.listener.ListenerNotifierManager;
import org.apache.shardingsphere.elasticjob.kernel.internal.storage.JobNodePath;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.base.LeaderExecutionCallback;
import org.apache.shardingsphere.elasticjob.reg.base.transaction.TransactionOperation;
import org.apache.shardingsphere.elasticjob.reg.exception.RegExceptionHandler;
import org.apache.shardingsphere.elasticjob.reg.listener.ConnectionStateChangedEventListener;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEventListener;

public final class JobNodeStorage {
    private final CoordinatorRegistryCenter regCenter;
    private final String jobName;
    private final JobNodePath jobNodePath;

    public JobNodeStorage(CoordinatorRegistryCenter regCenter, String jobName) {
        this.regCenter = regCenter;
        this.jobName = jobName;
        this.jobNodePath = new JobNodePath(jobName);
    }

    public boolean isJobNodeExisted(String node) {
        return this.regCenter.isExisted(this.jobNodePath.getFullPath(node));
    }

    public boolean isJobRootNodeExisted() {
        return this.regCenter.isExisted("/" + this.jobName);
    }

    public String getJobNodeData(String node) {
        return this.regCenter.get(this.jobNodePath.getFullPath(node));
    }

    public String getJobNodeDataDirectly(String node) {
        return this.regCenter.getDirectly(this.jobNodePath.getFullPath(node));
    }

    public List<String> getJobNodeChildrenKeys(String node) {
        return this.regCenter.getChildrenKeys(this.jobNodePath.getFullPath(node));
    }

    public String getJobRootNodeData() {
        return this.regCenter.get("/" + this.jobName);
    }

    public void createJobNodeIfNeeded(String node) {
        if (this.isJobRootNodeExisted() && !this.isJobNodeExisted(node)) {
            this.regCenter.persist(this.jobNodePath.getFullPath(node), "");
        }
    }

    public void removeJobNodeIfExisted(String node) {
        if (this.isJobNodeExisted(node)) {
            this.regCenter.remove(this.jobNodePath.getFullPath(node));
        }
    }

    public void fillJobNode(String node, Object value) {
        this.regCenter.persist(this.jobNodePath.getFullPath(node), value.toString());
    }

    public void fillEphemeralJobNode(String node, Object value) {
        this.regCenter.persistEphemeral(this.jobNodePath.getFullPath(node), value.toString());
    }

    public void updateJobNode(String node, Object value) {
        this.regCenter.update(this.jobNodePath.getFullPath(node), value.toString());
    }

    public void replaceJobNode(String node, Object value) {
        this.regCenter.persist(this.jobNodePath.getFullPath(node), value.toString());
    }

    public void replaceJobRootNode(Object value) {
        this.regCenter.persist("/" + this.jobName, value.toString());
    }

    public void executeInTransaction(List<TransactionOperation> transactionOperations) {
        ArrayList<TransactionOperation> result = new ArrayList<TransactionOperation>(transactionOperations.size() + 1);
        result.add(TransactionOperation.opCheckExists((String)"/"));
        result.addAll(transactionOperations);
        try {
            this.regCenter.executeInTransaction(result);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
    }

    public void executeInLeader(String latchNode, LeaderExecutionCallback callback) {
        this.regCenter.executeInLeader(this.jobNodePath.getFullPath(latchNode), callback);
    }

    public void addConnectionStateListener(ConnectionStateChangedEventListener listener) {
        this.regCenter.addConnectionStateChangedEventListener("/" + this.jobName, listener);
    }

    public void addDataListener(DataChangedEventListener listener) {
        Executor executor = ListenerNotifierManager.getInstance().getJobNotifyExecutor(this.jobName);
        this.regCenter.watch("/" + this.jobName, listener, executor);
    }

    public long getRegistryCenterTime() {
        return this.regCenter.getRegistryCenterTime(this.jobNodePath.getFullPath("systemTime/current"));
    }
}

