/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.exception.ShenyuAdminException;
import org.apache.shenyu.admin.mapper.RegistryMapper;
import org.apache.shenyu.admin.model.dto.RegistryDTO;
import org.apache.shenyu.admin.model.entity.RegistryDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.RegistryQuery;
import org.apache.shenyu.admin.model.vo.RegistryVO;
import org.apache.shenyu.admin.service.RegistryService;
import org.apache.shenyu.admin.transfer.RegistryTransfer;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.springframework.stereotype.Service;

@Service
public class RegistryServiceImpl
implements RegistryService {
    private final RegistryMapper registryMapper;

    public RegistryServiceImpl(RegistryMapper registryMapper) {
        this.registryMapper = registryMapper;
    }

    @Override
    public RegistryVO createOrUpdate(RegistryDTO registryDTO) {
        return StringUtils.isBlank((CharSequence)registryDTO.getId()) ? this.create(registryDTO) : this.update(registryDTO);
    }

    @Override
    public CommonPager<RegistryVO> listByPage(RegistryQuery registryQuery) {
        return PageResultUtils.result(registryQuery.getPageParameter(), () -> this.registryMapper.countByQuery(registryQuery), () -> this.registryMapper.selectByQuery(registryQuery).stream().map(RegistryTransfer.INSTANCE::mapToVo).collect(Collectors.toList()));
    }

    @Override
    public String delete(List<String> ids) {
        this.registryMapper.deleteByIds(ids);
        return "delete success";
    }

    @Override
    public RegistryVO findById(String id) {
        return RegistryTransfer.INSTANCE.mapToVo(this.registryMapper.selectById(id));
    }

    @Override
    public RegistryVO findByRegistryId(String registryId) {
        return RegistryTransfer.INSTANCE.mapToVo(this.registryMapper.selectByRegistryId(registryId));
    }

    @Override
    public List<RegistryVO> listAll() {
        List<RegistryDO> registryDOS = this.registryMapper.selectAll();
        return registryDOS.stream().map(RegistryTransfer.INSTANCE::mapToVo).collect(Collectors.toList());
    }

    private RegistryVO create(RegistryDTO registryDTO) {
        RegistryDO existRegistryDO = this.registryMapper.selectByRegistryId(registryDTO.getRegistryId());
        if (Objects.nonNull(existRegistryDO)) {
            throw new ShenyuAdminException("registry_id is already exist");
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        String id = UUIDUtils.getInstance().generateShortUuid();
        RegistryDO registryDO = RegistryDO.builder().id(id).registryId(registryDTO.getRegistryId()).protocol(registryDTO.getProtocol()).address(registryDTO.getAddress()).namespace(registryDTO.getNamespace()).username(registryDTO.getUsername()).password(registryDTO.getPassword()).registryGroup(registryDTO.getGroup()).dateCreated(currentTime).dateUpdated(currentTime).build();
        this.registryMapper.insert(registryDO);
        return RegistryTransfer.INSTANCE.mapToVo(registryDO);
    }

    private RegistryVO update(RegistryDTO registryDTO) {
        if (Objects.isNull(registryDTO) || Objects.isNull(registryDTO.getId())) {
            throw new ShenyuAdminException("registry is not exist");
        }
        RegistryDO existRegistryDO = this.registryMapper.selectByRegistryId(registryDTO.getRegistryId());
        if (Objects.nonNull(existRegistryDO) && !existRegistryDO.getId().equals(registryDTO.getId())) {
            throw new ShenyuAdminException("registry_id is already exist");
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        RegistryDO registryDO = RegistryDO.builder().id(registryDTO.getId()).registryId(registryDTO.getRegistryId()).protocol(registryDTO.getProtocol()).address(registryDTO.getAddress()).namespace(registryDTO.getNamespace()).username(registryDTO.getUsername()).password(registryDTO.getPassword()).registryGroup(registryDTO.getGroup()).dateUpdated(currentTime).build();
        return this.registryMapper.updateSelective(registryDO) > 0 ? RegistryTransfer.INSTANCE.mapToVo(registryDO) : null;
    }
}

