/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.inflater;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.geotiff.inflater.CompressionChannel;

final class LZW
extends CompressionChannel {
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private static final int FIRST_ADAPTATIVE_CODE = 258;
    private static final int OFFSET_TO_MAXIMUM = 1;
    private static final int MIN_CODE_SIZE = 9;
    private static final int MAX_CODE_SIZE = 12;
    private int codeSize;
    private static final int LOWEST_OFFSET_BIT = 12;
    private static final int LENGTH_MASK = 4095;
    private static final int STRING_ALIGNMENT = 2;
    private static final int PREALLOCATED_SPACE_IS_USED_MASK = Integer.MIN_VALUE;
    private static final int OFFSET_MASK = 0x7FFFF000;
    private static final int OFFSET_SHIFT = 10;
    private static final int OFFSET_LIMIT = 0x200000;
    private static final int LENGTH_MASK_FOR_ALLOCATE = 3;
    private final int[] entriesForCodes = new int[4095];
    private int previousCode;
    private int pendingOffset;
    private int pendingLength;
    private int indexOfFreeEntry = 258;
    private int indexOfFreeString;
    private byte[] stringsFromCode = new byte[49152];

    private static int length(int element) {
        return element & 0xFFF;
    }

    private static int offset(int element) {
        return (element & 0x7FFFF000) >>> 10;
    }

    private static int offsetAndLength(int offset, int length) {
        int element = offset << 10 | length;
        assert (LZW.offset(element) == offset) : offset;
        assert (LZW.length(element) == length) : length;
        return element;
    }

    private static boolean newEntryNeedsAllocation(int element) {
        return (element & 0x80000003) <= 0;
    }

    public LZW(ChannelDataInput input, StoreListeners listeners) {
        super(input, listeners);
        for (int i = 0; i < 256; ++i) {
            this.stringsFromCode[i << 2] = (byte)i;
        }
    }

    @Override
    public void setInputRegion(long start, long byteCount) throws IOException {
        super.setInputRegion(start, byteCount);
        this.clearTable();
        this.previousCode = 0;
        this.pendingOffset = 0;
        this.pendingLength = 0;
    }

    private void clearTable() {
        for (int i = 0; i < 256; ++i) {
            this.entriesForCodes[i] = i << 12 | 1;
        }
        Arrays.fill(this.entriesForCodes, 258, this.indexOfFreeEntry, 0);
        this.indexOfFreeEntry = 258;
        this.indexOfFreeString = 1024;
        this.codeSize = 9;
    }

    public final int readNextCode() throws IOException {
        try {
            return (int)this.input.readBits(this.codeSize);
        }
        catch (EOFException e) {
            if (this.finished()) {
                this.listeners.warning(null, (Exception)e);
                return 257;
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer target) throws IOException {
        int code;
        int start = target.position();
        int previousCode = this.previousCode;
        if (this.pendingLength != 0) {
            int n = Math.min(this.pendingLength, target.remaining());
            target.put(this.stringsFromCode, this.pendingOffset, n);
            this.pendingOffset += n;
            this.pendingLength -= n;
            if (this.pendingLength != 0 || previousCode == 257) {
                return n;
            }
        } else if (previousCode == 257 || this.finished()) {
            return -1;
        }
        int entryForCode = this.entriesForCodes[previousCode];
        int stringOffset = LZW.offset(entryForCode);
        int stringLength = LZW.length(entryForCode);
        int maximumIndex = (1 << this.codeSize) - 1;
        while ((code = this.readNextCode()) != 257) {
            block29: {
                if (code == 256) {
                    this.clearTable();
                    maximumIndex = 511;
                    while ((code = this.readNextCode()) == 256) {
                    }
                    if ((code & 0xFFFFFF00) != 0) {
                        if (code == 257) break;
                        throw this.unexpectedData();
                    }
                    stringLength = 1;
                    stringOffset = code << 2;
                    entryForCode = this.entriesForCodes[code];
                    assert (LZW.offsetAndLength(stringOffset, 1) == entryForCode) : code;
                    assert (Byte.toUnsignedInt(this.stringsFromCode[stringOffset]) == code) : code;
                    if (target.hasRemaining()) {
                        target.put((byte)code);
                        break block29;
                    } else {
                        this.pendingOffset = stringOffset;
                        this.pendingLength = stringLength;
                        break;
                    }
                }
                assert (entryForCode == this.entriesForCodes[previousCode]) : previousCode;
                assert (stringOffset == LZW.offset(entryForCode)) : stringOffset;
                assert (stringLength == LZW.length(entryForCode)) : stringLength;
                boolean allocate = LZW.newEntryNeedsAllocation(entryForCode);
                int newOffset = allocate ? this.indexOfFreeString : stringOffset;
                int lastNewByte = newOffset + stringLength;
                if (allocate) {
                    this.indexOfFreeString = lastNewByte + (~lastNewByte & 3) + 1;
                    assert ((this.indexOfFreeString & 3) == 0) : stringLength;
                    if (this.indexOfFreeString > this.stringsFromCode.length) {
                        int capacity = Math.min(this.indexOfFreeString * 2, 0x200000);
                        if (this.indexOfFreeString >= capacity) {
                            throw new IOException("Dictionary overflow");
                        }
                        this.stringsFromCode = Arrays.copyOf(this.stringsFromCode, capacity);
                    }
                    System.arraycopy(this.stringsFromCode, stringOffset, this.stringsFromCode, newOffset, stringLength);
                }
                this.entriesForCodes[previousCode] = entryForCode | Integer.MIN_VALUE;
                int newLength = stringLength + 1;
                int newEntry = LZW.offsetAndLength(newOffset, newLength);
                entryForCode = this.entriesForCodes[code];
                if (entryForCode != 0) {
                    stringOffset = LZW.offset(entryForCode);
                    stringLength = LZW.length(entryForCode);
                } else {
                    stringOffset = newOffset;
                    stringLength = newLength;
                    entryForCode = newEntry;
                    code = this.indexOfFreeEntry;
                }
                assert (this.stringsFromCode[newOffset] == this.stringsFromCode[LZW.offset(this.entriesForCodes[previousCode])]) : code;
                this.stringsFromCode[lastNewByte] = this.stringsFromCode[stringOffset];
                try {
                    this.entriesForCodes[this.indexOfFreeEntry] = newEntry;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw (IOException)this.unexpectedData().initCause(e);
                }
                if (++this.indexOfFreeEntry == maximumIndex) {
                    if (this.codeSize < 12) {
                        maximumIndex = (1 << ++this.codeSize) - 1;
                    } else assert (this.indexOfFreeEntry == this.entriesForCodes.length) : this.indexOfFreeEntry;
                }
                int n = Math.min(stringLength, target.remaining());
                target.put(this.stringsFromCode, stringOffset, n);
                if (n != stringLength) {
                    this.pendingOffset = stringOffset + n;
                    this.pendingLength = stringLength - n;
                    break;
                }
            }
            previousCode = code;
        }
        this.previousCode = code;
        return target.position() - start;
    }

    private IOException unexpectedData() {
        return new IOException(this.resources().getString((short)31, this.input.filename, "LZW"));
    }
}

