/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.internal.shared.FeatureExpression;
import org.apache.sis.feature.internal.shared.FeatureProjection;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.filter.DefaultFilterFactory;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.internal.shared.ListingPropertyVisitor;
import org.apache.sis.filter.internal.shared.SortByComparator;
import org.apache.sis.pending.geoapi.filter.Literal;
import org.apache.sis.pending.geoapi.filter.SortBy;
import org.apache.sis.pending.geoapi.filter.SortProperty;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.apache.sis.pending.jdk.JDK19;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.FeatureSubset;
import org.apache.sis.storage.Query;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.iso.Names;
import org.opengis.geometry.Envelope;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class FeatureQuery
extends Query
implements Cloneable,
Emptiable,
Serializable {
    private static final long serialVersionUID = -5841189659773611160L;
    private static final long UNLIMITED = -1L;
    private NamedExpression[] projection;
    private Filter<? super AbstractFeature> selection;
    private long skip;
    private long limit;
    private SortBy<AbstractFeature> sortBy;
    private Quantity<Length> linearResolution;

    public FeatureQuery() {
        this.limit = -1L;
    }

    public FeatureQuery(FeatureQuery other) {
        this.projection = other.projection;
        this.selection = other.selection;
        this.skip = other.skip;
        this.limit = other.limit;
        this.sortBy = other.sortBy;
        this.linearResolution = other.linearResolution;
    }

    public boolean isEmpty() {
        return this.projection == null && this.selection == null && this.skip == 0L && this.limit < 0L && this.sortBy == null && this.linearResolution == null;
    }

    @Override
    public void setProjection(String ... properties) {
        NamedExpression[] wrappers = null;
        if (properties != null) {
            ArgumentChecks.ensureNonEmpty((String)"properties", (Object[])properties);
            DefaultFilterFactory ff = DefaultFilterFactory.forFeatures();
            wrappers = new NamedExpression[properties.length];
            for (int i = 0; i < wrappers.length; ++i) {
                String p = properties[i];
                ArgumentChecks.ensureNonNullElement((String)"properties", (int)i, (Object)p);
                wrappers[i] = new NamedExpression(ff.property(p));
            }
        }
        this.setProjection(wrappers);
    }

    @SafeVarargs
    public final void setProjection(Expression<? super AbstractFeature, ?> ... properties) {
        NamedExpression[] wrappers = null;
        if (properties != null) {
            ArgumentChecks.ensureNonEmpty((String)"properties", (Object[])properties);
            wrappers = new NamedExpression[properties.length];
            for (int i = 0; i < wrappers.length; ++i) {
                Expression<? super AbstractFeature, ?> e = properties[i];
                ArgumentChecks.ensureNonNullElement((String)"properties", (int)i, e);
                wrappers[i] = new NamedExpression(e);
            }
        }
        this.setProjection(wrappers);
    }

    public void setProjection(NamedExpression ... properties) {
        if (properties != null) {
            ArgumentChecks.ensureNonEmpty((String)"properties", (Object[])properties);
            properties = (NamedExpression[])properties.clone();
            LinkedHashMap uniques = JDK19.newLinkedHashMap((int)properties.length);
            for (int i = 0; i < properties.length; ++i) {
                NamedExpression c = properties[i];
                ArgumentChecks.ensureNonNullElement((String)"properties", (int)i, (Object)c);
                Expression<? super AbstractFeature, ?> alias = c.alias();
                Object key = alias != null ? alias : c.expression();
                Integer p = uniques.putIfAbsent(key, i);
                if (p == null) continue;
                if (key instanceof Expression) {
                    key = FeatureQuery.label(key);
                }
                throw new IllegalArgumentException(Resources.format((short)54, key, p, i));
            }
        }
        this.projection = properties;
    }

    public NamedExpression[] getProjection() {
        return this.projection != null ? (NamedExpression[])this.projection.clone() : null;
    }

    @Override
    public void setSelection(Envelope domain) {
        Filter filter = null;
        if (domain != null) {
            DefaultFilterFactory ff = DefaultFilterFactory.forFeatures();
            filter = ff.bbox(ff.property("sis:geometry"), domain);
        }
        this.setSelection(filter);
    }

    public void setSelection(Filter<? super AbstractFeature> selection) {
        this.selection = selection;
    }

    public Filter<? super AbstractFeature> getSelection() {
        return this.selection;
    }

    public void setOffset(long skip) {
        ArgumentChecks.ensurePositive((String)"skip", (long)skip);
        this.skip = skip;
    }

    public long getOffset() {
        return this.skip;
    }

    public void setUnlimited() {
        this.limit = -1L;
    }

    public void setLimit(long limit) {
        ArgumentChecks.ensurePositive((String)"limit", (long)limit);
        this.limit = limit;
    }

    public OptionalLong getLimit() {
        return this.limit >= 0L ? OptionalLong.of(this.limit) : OptionalLong.empty();
    }

    @SafeVarargs
    final void setSortBy(SortProperty<AbstractFeature> ... properties) {
        SortByComparator sortBy = null;
        if (properties != null) {
            sortBy = SortByComparator.create(properties);
        }
        this.setSortBy((SortBy<AbstractFeature>)sortBy);
    }

    final void setSortBy(SortBy<AbstractFeature> sortBy) {
        this.sortBy = sortBy;
    }

    final SortBy<AbstractFeature> getSortBy() {
        return this.sortBy;
    }

    public void setLinearResolution(Quantity<Length> linearResolution) {
        this.linearResolution = linearResolution;
    }

    public Quantity<Length> getLinearResolution() {
        return this.linearResolution;
    }

    private static String label(Expression<?, ?> expression) {
        String text;
        if (expression instanceof Literal) {
            text = String.valueOf(((Literal)expression).getValue());
        } else if (expression instanceof ValueReference) {
            text = ((ValueReference)expression).getXPath();
        } else {
            return expression.getFunctionName().toString();
        }
        return CharSequences.shortSentence((CharSequence)text, (int)40).toString();
    }

    public Set<String> getXPaths() {
        Set xpaths = ListingPropertyVisitor.xpaths(this.selection, null);
        if (this.projection != null) {
            for (NamedExpression e : this.projection) {
                xpaths = ListingPropertyVisitor.xpaths(e.expression(), (Set)xpaths);
            }
        }
        return xpaths;
    }

    final Optional<FeatureProjection> project(DefaultFeatureType sourceType, Locale locale) {
        if (this.projection == null) {
            return Optional.empty();
        }
        FeatureProjectionBuilder builder = new FeatureProjectionBuilder(sourceType, locale);
        for (int column = 0; column < this.projection.length; ++column) {
            NamedExpression item = this.projection[column];
            if (item.addTo(builder)) continue;
            InternationalString name = item.expression().getFunctionName().toInternationalString();
            throw new IllegalArgumentException(Resources.forLocale(locale).getString((short)60, column, name));
        }
        builder.setName(sourceType.getName());
        return builder.project();
    }

    protected FeatureSet execute(FeatureSet source) throws DataStoreException {
        if (this.isEmpty()) {
            return source;
        }
        FeatureQuery query = this.clone();
        query.optimize(source);
        return new FeatureSubset(source, query);
    }

    protected void optimize(FeatureSet source) throws DataStoreException {
        if (this.selection != null) {
            Optimization optimization = new Optimization();
            optimization.setFeatureType(source.getType());
            this.selection = optimization.apply(this.selection);
        }
    }

    public FeatureQuery clone() {
        try {
            return (FeatureQuery)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        return 97 * Arrays.hashCode(this.projection) + 31 * Objects.hashCode(this.selection) + 7 * Objects.hashCode(this.sortBy) + Long.hashCode(this.limit ^ this.skip) + 3 * Objects.hashCode(this.linearResolution);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            FeatureQuery other = (FeatureQuery)obj;
            return this.skip == other.skip && this.limit == other.limit && Objects.equals(this.selection, other.selection) && Arrays.equals(this.projection, other.projection) && Objects.equals(this.sortBy, other.sortBy) && Objects.equals(this.linearResolution, other.linearResolution);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("SELECT ");
        if (this.projection != null) {
            for (int i = 0; i < this.projection.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                this.projection[i].appendTo(sb);
            }
        } else {
            sb.append('*');
        }
        if (this.selection != null) {
            sb.append(" WHERE ").append(this.selection);
        }
        if (this.sortBy != null) {
            String separator = " ORDER BY ";
            for (SortProperty p : this.sortBy.getSortProperties()) {
                sb.append(separator);
                separator = ", ";
                sb.append(p.getValueReference().getXPath()).append(' ').append(p.getSortOrder());
            }
        }
        if (this.linearResolution != null) {
            sb.append(" RESOLUTION ").append(this.linearResolution);
        }
        if (this.limit != -1L) {
            sb.append(" LIMIT ").append(this.limit);
        }
        if (this.skip != 0L) {
            sb.append(" OFFSET ").append(this.skip);
        }
        return sb.toString();
    }

    public static final class NamedExpression
    implements Serializable {
        private static final long serialVersionUID = 4547204390645035145L;
        @Deprecated(since="1.5")
        public final Expression<? super AbstractFeature, ?> expression;
        @Deprecated(since="1.5")
        public final GenericName alias;
        @Deprecated(since="1.5")
        public final ProjectionType type;

        public NamedExpression(Expression<? super AbstractFeature, ?> expression) {
            this(expression, (GenericName)null);
        }

        public NamedExpression(Expression<? super AbstractFeature, ?> expression, GenericName alias) {
            this(expression, alias, ProjectionType.STORED);
        }

        public NamedExpression(Expression<? super AbstractFeature, ?> expression, String alias) {
            this.expression = Objects.requireNonNull(expression);
            this.alias = alias != null ? Names.createLocalName(null, null, (CharSequence)alias) : null;
            this.type = ProjectionType.STORED;
        }

        public NamedExpression(Expression<? super AbstractFeature, ?> expression, GenericName alias, ProjectionType type) {
            this.expression = Objects.requireNonNull(expression);
            this.type = Objects.requireNonNull(type);
            this.alias = alias;
        }

        final boolean addTo(FeatureProjectionBuilder builder) {
            FeatureProjectionBuilder.Item item;
            FeatureExpression fex = FeatureExpression.castOrCopy(this.expression);
            if (fex != null && (item = fex.expectedType(builder)) != null) {
                item.setName(this.alias);
                item.setValueGetter(this.expression, this.type == ProjectionType.STORED);
                return true;
            }
            return false;
        }

        public Expression<? super AbstractFeature, ?> expression() {
            return this.expression;
        }

        public GenericName alias() {
            return this.alias;
        }

        public ProjectionType type() {
            return this.type;
        }

        public int hashCode() {
            return 37 * this.expression.hashCode() + Objects.hashCode(this.alias) + this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && this.getClass() == obj.getClass()) {
                NamedExpression other = (NamedExpression)obj;
                return this.expression.equals(other.expression) && Objects.equals(this.alias, other.alias) && this.type == other.type;
            }
            return false;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("SELECT ");
            this.appendTo(buffer);
            return buffer.toString();
        }

        final void appendTo(StringBuilder buffer) {
            if (this.expression instanceof Literal) {
                buffer.append('\u2018').append(((Literal)this.expression).getValue()).append('\u2019');
            } else if (this.expression instanceof ValueReference) {
                buffer.append('\u201c').append(((ValueReference)this.expression).getXPath()).append('\u201d');
            } else {
                buffer.append("=\u201c").append(this.expression.getFunctionName()).append("\u201d()");
            }
            if (this.type != ProjectionType.STORED) {
                buffer.append(' ').append((Object)this.type);
            }
            if (this.alias != null) {
                buffer.append(" AS \u201c").append(this.alias).append('\u201d');
            }
        }
    }

    public static enum ProjectionType {
        STORED,
        COMPUTING;

    }
}

