/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.grpc.GrpcExceptionHandlerFunction;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Maps;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

@UnstableApi
public final class GrpcExceptionHandlerFunctionBuilder {
    @VisibleForTesting
    final LinkedList<Map.Entry<Class<? extends Throwable>, GrpcExceptionHandlerFunction>> exceptionMappings = new LinkedList();

    GrpcExceptionHandlerFunctionBuilder() {
    }

    public GrpcExceptionHandlerFunctionBuilder on(Class<? extends Throwable> exceptionType, Status status) {
        Objects.requireNonNull(status, "status");
        return this.on(exceptionType, (RequestContext ctx, Status unused, Throwable cause, Metadata metadata) -> status);
    }

    public <T extends Throwable> GrpcExceptionHandlerFunctionBuilder on(Class<T> exceptionType, BiFunction<T, Metadata, Status> exceptionHandler) {
        Objects.requireNonNull(exceptionType, "exceptionType");
        Objects.requireNonNull(exceptionHandler, "exceptionHandler");
        return this.on(exceptionType, (RequestContext ctx, Status status, Throwable cause, Metadata metadata) -> (Status)exceptionHandler.apply(cause, metadata));
    }

    public GrpcExceptionHandlerFunctionBuilder on(Class<? extends Throwable> exceptionType, GrpcExceptionHandlerFunction exceptionHandler) {
        Objects.requireNonNull(exceptionType, "exceptionType");
        Objects.requireNonNull(exceptionHandler, "exceptionHandler");
        ListIterator<Map.Entry> it = this.exceptionMappings.listIterator();
        while (it.hasNext()) {
            Map.Entry next = (Map.Entry)it.next();
            Class oldExceptionType = (Class)next.getKey();
            Preconditions.checkArgument((oldExceptionType != exceptionType ? 1 : 0) != 0, (String)"%s is already added with %s", (Object)oldExceptionType, next.getValue());
            if (!oldExceptionType.isAssignableFrom(exceptionType)) continue;
            it.previous();
            it.add(Maps.immutableEntry(exceptionType, (Object)exceptionHandler));
            return this;
        }
        this.exceptionMappings.add(Maps.immutableEntry(exceptionType, (Object)exceptionHandler));
        return this;
    }

    public GrpcExceptionHandlerFunction build() {
        Preconditions.checkState((!this.exceptionMappings.isEmpty() ? 1 : 0) != 0, (Object)"no exception handler is added.");
        ImmutableList mappings = ImmutableList.copyOf(this.exceptionMappings);
        return (arg_0, arg_1, arg_2, arg_3) -> GrpcExceptionHandlerFunctionBuilder.lambda$build$2((List)mappings, arg_0, arg_1, arg_2, arg_3);
    }

    private static /* synthetic */ Status lambda$build$2(List mappings, RequestContext ctx, Status status, Throwable cause, Metadata metadata) {
        for (Map.Entry mapping : mappings) {
            if (!((Class)mapping.getKey()).isInstance(cause)) continue;
            Status newStatus = ((GrpcExceptionHandlerFunction)mapping.getValue()).apply(ctx, status, cause, metadata);
            return newStatus == null ? null : newStatus.withCause(cause);
        }
        return null;
    }
}

