/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.source;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.source.ScopeDefaultColumn;
import org.apache.skywalking.oap.server.core.source.Source;

@ScopeDeclaration(id=49, name="ServiceLabel")
@ScopeDefaultColumn.VirtualColumnDefinition(fieldName="entityId", columnName="entity_id", isID=true, type=String.class)
public class ServiceLabel
extends Source {
    private volatile String entityId;
    private String serviceId;
    private boolean isServiceNormal;
    private String serviceName;
    private String label;

    @Override
    public int scope() {
        return 49;
    }

    @Override
    public String getEntityId() {
        if (this.entityId == null) {
            this.entityId = this.serviceId + "_" + new String(Base64.getEncoder().encode(this.label.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        return this.entityId;
    }

    @Override
    public void prepare() {
        this.serviceId = IDManager.ServiceID.buildId(this.serviceName, this.isServiceNormal);
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public void setServiceNormal(boolean isServiceNormal) {
        this.isServiceNormal = isServiceNormal;
    }

    @Generated
    public boolean isServiceNormal() {
        return this.isServiceNormal;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }
}

