/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.EventLoopThreadFactory;
import com.linecorp.armeria.common.util.NonEventLoopThreadFactory;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;

public final class ThreadFactoryBuilder {
    private final String threadNamePrefix;
    private boolean daemon;
    private boolean eventLoop;
    private int priority = 5;
    private Function<? super Runnable, ? extends Runnable> taskFunction = Function.identity();
    @Nullable
    private ThreadGroup threadGroup;

    ThreadFactoryBuilder(String threadNamePrefix) {
        this.threadNamePrefix = Objects.requireNonNull(threadNamePrefix, "threadNamePrefix");
    }

    public ThreadFactoryBuilder daemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadFactoryBuilder eventLoop(boolean eventLoop) {
        this.eventLoop = eventLoop;
        return this;
    }

    public ThreadFactoryBuilder priority(int priority) {
        Preconditions.checkArgument(priority >= 1 && priority <= 10, "priority: %s (expected: Thread.MIN_PRIORITY <= priority <= Thread.MAX_PRIORITY)", priority);
        this.priority = priority;
        return this;
    }

    public ThreadFactoryBuilder threadGroup(ThreadGroup threadGroup) {
        this.threadGroup = Objects.requireNonNull(threadGroup, "threadGroup");
        return this;
    }

    public ThreadFactoryBuilder taskFunction(Function<? super Runnable, ? extends Runnable> taskFunction) {
        this.taskFunction = Objects.requireNonNull(taskFunction, "taskFunction");
        return this;
    }

    public ThreadFactory build() {
        if (this.eventLoop) {
            return new EventLoopThreadFactory(this.threadNamePrefix, this.daemon, this.priority, this.threadGroup, this.taskFunction);
        }
        return new NonEventLoopThreadFactory(this.threadNamePrefix, this.daemon, this.priority, this.threadGroup, this.taskFunction);
    }
}

