/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.skywalking.apm.plugin.pulsar;

import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.common.api.proto.PulsarApi.KeyValue;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.plugin.pulsar.common.MessagePropertiesInjector;

/**
 * Message properties injector implementation for pulsar client version 2.7.x
 */
public class MessagePropertiesInjectorV27 implements MessagePropertiesInjector {

    @Override
    public void inject(MessageImpl message, CarrierItem carrierItem) {
        message.getMessageBuilder().addProperties(
                KeyValue.newBuilder()
                        .setKey(carrierItem.getHeadKey())
                        .setValue(carrierItem.getHeadValue()));
    }
}
