/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.activation.opentracing.span;

import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.toolkit.opentracing.SkywalkingSpanBuilder;
import org.apache.skywalking.apm.toolkit.opentracing.Tag;
import org.apache.skywalking.apm.util.StringUtil;

public class ConstructorWithSpanBuilderInterceptor
implements InstanceConstructorInterceptor {
    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        SkywalkingSpanBuilder spanBuilder = (SkywalkingSpanBuilder)allArguments[0];
        AbstractSpan span = spanBuilder.isEntry() ? ContextManager.createEntrySpan((String)spanBuilder.getOperationName(), null) : (spanBuilder.isExit() && !StringUtil.isEmpty((String)spanBuilder.getPeer()) ? ContextManager.createExitSpan((String)spanBuilder.getOperationName(), (String)this.buildRemotePeer(spanBuilder)) : ContextManager.createLocalSpan((String)spanBuilder.getOperationName()));
        for (Tag tag : spanBuilder.getTags()) {
            span.tag(Tags.ofKey((String)tag.getKey()), tag.getValue());
        }
        if (spanBuilder.isError()) {
            span.errorOccurred();
        }
        objInst.setSkyWalkingDynamicField((Object)span);
    }

    private String buildRemotePeer(SkywalkingSpanBuilder spanBuilder) {
        return spanBuilder.getPeer() + (spanBuilder.getPort() == 0 ? "" : ":" + spanBuilder.getPort());
    }
}

