/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.okhttp.common;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.okhttp.common.EnhanceRequiredInfo;

public class AsyncCallInterceptor
implements InstanceConstructorInterceptor,
InstanceMethodsAroundInterceptor {
    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        EnhancedInstance realCallInstance = (EnhancedInstance)allArguments[1];
        Object enhanceRequireInfo = realCallInstance.getSkyWalkingDynamicField();
        objInst.setSkyWalkingDynamicField(enhanceRequireInfo);
    }

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        EnhanceRequiredInfo enhanceRequiredInfo = (EnhanceRequiredInfo)objInst.getSkyWalkingDynamicField();
        ContextManager.createLocalSpan((String)"Async/execute");
        ContextManager.continued((ContextSnapshot)enhanceRequiredInfo.getContextSnapshot());
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

