/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.FetchMetricsRegistry;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.SensorBuilder;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.MetricName;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.metrics.Metrics;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.metrics.Sensor;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.metrics.stats.WindowedCount;

public class FetchMetricsManager {
    private final Metrics metrics;
    private final FetchMetricsRegistry metricsRegistry;
    private final Sensor throttleTime;
    private final Sensor bytesFetched;
    private final Sensor recordsFetched;
    private final Sensor fetchLatency;
    private final Sensor recordsLag;
    private final Sensor recordsLead;
    private int assignmentId = 0;
    private Set<TopicPartition> assignedPartitions = Collections.emptySet();

    public FetchMetricsManager(Metrics metrics, FetchMetricsRegistry metricsRegistry) {
        this.metrics = metrics;
        this.metricsRegistry = metricsRegistry;
        this.throttleTime = new SensorBuilder(metrics, "fetch-throttle-time").withAvg(metricsRegistry.fetchThrottleTimeAvg).withMax(metricsRegistry.fetchThrottleTimeMax).build();
        this.bytesFetched = new SensorBuilder(metrics, "bytes-fetched").withAvg(metricsRegistry.fetchSizeAvg).withMax(metricsRegistry.fetchSizeMax).withMeter(metricsRegistry.bytesConsumedRate, metricsRegistry.bytesConsumedTotal).build();
        this.recordsFetched = new SensorBuilder(metrics, "records-fetched").withAvg(metricsRegistry.recordsPerRequestAvg).withMeter(metricsRegistry.recordsConsumedRate, metricsRegistry.recordsConsumedTotal).build();
        this.fetchLatency = new SensorBuilder(metrics, "fetch-latency").withAvg(metricsRegistry.fetchLatencyAvg).withMax(metricsRegistry.fetchLatencyMax).withMeter(new WindowedCount(), metricsRegistry.fetchRequestRate, metricsRegistry.fetchRequestTotal).build();
        this.recordsLag = new SensorBuilder(metrics, "records-lag").withMax(metricsRegistry.recordsLagMax).build();
        this.recordsLead = new SensorBuilder(metrics, "records-lead").withMin(metricsRegistry.recordsLeadMin).build();
    }

    public Sensor throttleTimeSensor() {
        return this.throttleTime;
    }

    void recordLatency(long requestLatencyMs) {
        this.fetchLatency.record(requestLatencyMs);
    }

    void recordBytesFetched(int bytes) {
        this.bytesFetched.record(bytes);
    }

    void recordRecordsFetched(int records) {
        this.recordsFetched.record(records);
    }

    void recordBytesFetched(String topic, int bytes) {
        String name = FetchMetricsManager.topicBytesFetchedMetricName(topic);
        Sensor bytesFetched = new SensorBuilder(this.metrics, name, () -> FetchMetricsManager.topicTags(topic)).withAvg(this.metricsRegistry.topicFetchSizeAvg).withMax(this.metricsRegistry.topicFetchSizeMax).withMeter(this.metricsRegistry.topicBytesConsumedRate, this.metricsRegistry.topicBytesConsumedTotal).build();
        bytesFetched.record(bytes);
    }

    void recordRecordsFetched(String topic, int records) {
        String name = FetchMetricsManager.topicRecordsFetchedMetricName(topic);
        Sensor recordsFetched = new SensorBuilder(this.metrics, name, () -> FetchMetricsManager.topicTags(topic)).withAvg(this.metricsRegistry.topicRecordsPerRequestAvg).withMeter(this.metricsRegistry.topicRecordsConsumedRate, this.metricsRegistry.topicRecordsConsumedTotal).build();
        recordsFetched.record(records);
    }

    void recordPartitionLag(TopicPartition tp, long lag) {
        this.recordsLag.record(lag);
        String name = FetchMetricsManager.partitionRecordsLagMetricName(tp);
        Sensor recordsLag = new SensorBuilder(this.metrics, name, () -> FetchMetricsManager.topicPartitionTags(tp)).withValue(this.metricsRegistry.partitionRecordsLag).withMax(this.metricsRegistry.partitionRecordsLagMax).withAvg(this.metricsRegistry.partitionRecordsLagAvg).build();
        recordsLag.record(lag);
    }

    void recordPartitionLead(TopicPartition tp, long lead) {
        this.recordsLead.record(lead);
        String name = FetchMetricsManager.partitionRecordsLeadMetricName(tp);
        Sensor recordsLead = new SensorBuilder(this.metrics, name, () -> FetchMetricsManager.topicPartitionTags(tp)).withValue(this.metricsRegistry.partitionRecordsLead).withMin(this.metricsRegistry.partitionRecordsLeadMin).withAvg(this.metricsRegistry.partitionRecordsLeadAvg).build();
        recordsLead.record(lead);
    }

    void maybeUpdateAssignment(SubscriptionState subscription) {
        int newAssignmentId = subscription.assignmentId();
        if (this.assignmentId != newAssignmentId) {
            Set<TopicPartition> newAssignedPartitions = subscription.assignedPartitions();
            for (TopicPartition tp : this.assignedPartitions) {
                if (newAssignedPartitions.contains(tp)) continue;
                this.metrics.removeSensor(FetchMetricsManager.partitionRecordsLagMetricName(tp));
                this.metrics.removeSensor(FetchMetricsManager.partitionRecordsLeadMetricName(tp));
                this.metrics.removeMetric(this.partitionPreferredReadReplicaMetricName(tp));
            }
            for (TopicPartition tp : newAssignedPartitions) {
                if (this.assignedPartitions.contains(tp)) continue;
                MetricName metricName = this.partitionPreferredReadReplicaMetricName(tp);
                this.metrics.addMetricIfAbsent(metricName, null, (config, now) -> subscription.preferredReadReplica(tp, 0L).orElse(-1));
            }
            this.assignedPartitions = newAssignedPartitions;
            this.assignmentId = newAssignmentId;
        }
    }

    private static String topicBytesFetchedMetricName(String topic) {
        return "topic." + topic + ".bytes-fetched";
    }

    private static String topicRecordsFetchedMetricName(String topic) {
        return "topic." + topic + ".records-fetched";
    }

    private static String partitionRecordsLeadMetricName(TopicPartition tp) {
        return tp + ".records-lead";
    }

    private static String partitionRecordsLagMetricName(TopicPartition tp) {
        return tp + ".records-lag";
    }

    private MetricName partitionPreferredReadReplicaMetricName(TopicPartition tp) {
        Map<String, String> metricTags = FetchMetricsManager.topicPartitionTags(tp);
        return this.metrics.metricInstance(this.metricsRegistry.partitionPreferredReadReplica, metricTags);
    }

    static Map<String, String> topicTags(String topic) {
        HashMap<String, String> metricTags = new HashMap<String, String>(1);
        metricTags.put("topic", topic.replace('.', '_'));
        return metricTags;
    }

    static Map<String, String> topicPartitionTags(TopicPartition tp) {
        HashMap<String, String> metricTags = new HashMap<String, String>(2);
        metricTags.put("topic", tp.topic().replace('.', '_'));
        metricTags.put("partition", String.valueOf(tp.partition()));
        return metricTags;
    }
}

