/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.events;

import java.util.Objects;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.Uuid;

public abstract class ApplicationEvent {
    private final Type type;
    private final Uuid id;

    protected ApplicationEvent(Type type) {
        this.type = Objects.requireNonNull(type);
        this.id = Uuid.randomUuid();
    }

    public Type type() {
        return this.type;
    }

    public Uuid id() {
        return this.id;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationEvent that = (ApplicationEvent)o;
        return this.type == that.type && this.id.equals(that.id);
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id});
    }

    protected String toStringBase() {
        return "type=" + (Object)((Object)this.type) + ", id=" + this.id;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{" + this.toStringBase() + "}";
    }

    public static enum Type {
        COMMIT_ASYNC,
        COMMIT_SYNC,
        POLL,
        FETCH_COMMITTED_OFFSETS,
        NEW_TOPICS_METADATA_UPDATE,
        ASSIGNMENT_CHANGE,
        LIST_OFFSETS,
        RESET_POSITIONS,
        VALIDATE_POSITIONS,
        TOPIC_METADATA,
        ALL_TOPICS_METADATA,
        SUBSCRIPTION_CHANGE,
        UNSUBSCRIBE,
        CONSUMER_REBALANCE_LISTENER_CALLBACK_COMPLETED,
        COMMIT_ON_CLOSE,
        SHARE_FETCH,
        SHARE_ACKNOWLEDGE_ASYNC,
        SHARE_ACKNOWLEDGE_SYNC,
        SHARE_SUBSCRIPTION_CHANGE,
        SHARE_UNSUBSCRIBE,
        SHARE_ACKNOWLEDGE_ON_CLOSE;

    }
}

