/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.Node;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicIdPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.Uuid;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.MemoryRecords;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.Records;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractResponse;

public class ShareFetchResponse
extends AbstractResponse {
    private final ShareFetchResponseData data;
    private volatile LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> responseData = null;

    public ShareFetchResponse(ShareFetchResponseData data) {
        super(ApiKeys.SHARE_FETCH);
        this.data = data;
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public ShareFetchResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        this.data.responses().forEach(topic -> topic.partitions().forEach(partition -> this.updateErrorCounts(counts, Errors.forCode(partition.errorCode()))));
        return counts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> responseData(Map<Uuid, String> topicNames) {
        if (this.responseData == null) {
            ShareFetchResponse shareFetchResponse = this;
            synchronized (shareFetchResponse) {
                if (this.responseData == null) {
                    LinkedHashMap responseDataTmp = new LinkedHashMap();
                    this.data.responses().forEach(topicResponse -> {
                        String name = (String)topicNames.get(topicResponse.topicId());
                        if (name != null) {
                            topicResponse.partitions().forEach(partitionData -> responseDataTmp.put(new TopicIdPartition(topicResponse.topicId(), new TopicPartition(name, partitionData.partitionIndex())), partitionData));
                        }
                    });
                    this.responseData = responseDataTmp;
                }
            }
        }
        return this.responseData;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static ShareFetchResponse parse(ByteBuffer buffer, short version) {
        return new ShareFetchResponse(new ShareFetchResponseData(new ByteBufferAccessor(buffer), version));
    }

    public static Records recordsOrFail(ShareFetchResponseData.PartitionData partition) {
        if (partition.records() == null) {
            return MemoryRecords.EMPTY;
        }
        if (partition.records() instanceof Records) {
            return (Records)partition.records();
        }
        throw new ClassCastException("The record type is " + partition.records().getClass().getSimpleName() + ", which is not a subtype of " + Records.class.getSimpleName() + ". This method is only safe to call if the `ShareFetchResponse` was deserialized from bytes.");
    }

    public static int sizeOf(short version, Iterator<Map.Entry<TopicIdPartition, ShareFetchResponseData.PartitionData>> partIterator) {
        ShareFetchResponseData data = ShareFetchResponse.toMessage(Errors.NONE, 0, partIterator, Collections.emptyList());
        ObjectSerializationCache cache = new ObjectSerializationCache();
        return 4 + data.size(cache, version);
    }

    public static int recordsSize(ShareFetchResponseData.PartitionData partition) {
        return partition.records() == null ? 0 : partition.records().sizeInBytes();
    }

    public static ShareFetchResponse of(Errors error, int throttleTimeMs, LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> responseData, List<Node> nodeEndpoints) {
        return new ShareFetchResponse(ShareFetchResponse.toMessage(error, throttleTimeMs, responseData.entrySet().iterator(), nodeEndpoints));
    }

    public static ShareFetchResponseData toMessage(Errors error, int throttleTimeMs, Iterator<Map.Entry<TopicIdPartition, ShareFetchResponseData.PartitionData>> partIterator, List<Node> nodeEndpoints) {
        LinkedHashMap<Uuid, ShareFetchResponseData.ShareFetchableTopicResponse> topicResponseList = new LinkedHashMap<Uuid, ShareFetchResponseData.ShareFetchableTopicResponse>();
        while (partIterator.hasNext()) {
            Map.Entry<TopicIdPartition, ShareFetchResponseData.PartitionData> entry = partIterator.next();
            ShareFetchResponseData.PartitionData partitionData = entry.getValue();
            partitionData.setPartitionIndex(entry.getKey().topicPartition().partition());
            if (topicResponseList.containsKey(entry.getKey().topicId())) {
                ((ShareFetchResponseData.ShareFetchableTopicResponse)topicResponseList.get(entry.getKey().topicId())).partitions().add(partitionData);
                continue;
            }
            ArrayList<ShareFetchResponseData.PartitionData> partitionResponses = new ArrayList<ShareFetchResponseData.PartitionData>();
            partitionResponses.add(partitionData);
            topicResponseList.put(entry.getKey().topicId(), new ShareFetchResponseData.ShareFetchableTopicResponse().setTopicId(entry.getKey().topicId()).setPartitions(partitionResponses));
        }
        ShareFetchResponseData data = new ShareFetchResponseData();
        nodeEndpoints.forEach(endpoint -> data.nodeEndpoints().add(new ShareFetchResponseData.NodeEndpoint().setNodeId(endpoint.id()).setHost(endpoint.host()).setPort(endpoint.port()).setRack(endpoint.rack())));
        return data.setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()).setResponses(new ArrayList<ShareFetchResponseData.ShareFetchableTopicResponse>(topicResponseList.values()));
    }

    public static ShareFetchResponseData.PartitionData partitionResponse(TopicIdPartition topicIdPartition, Errors error) {
        return ShareFetchResponse.partitionResponse(topicIdPartition.topicPartition().partition(), error);
    }

    public static ShareFetchResponseData.PartitionData partitionResponse(int partition, Errors error) {
        return new ShareFetchResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(error.code());
    }
}

