/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jackrabbit.util.Text;

public class Tree<E> {
    private final char separator;
    private Node<E> root = new Node(null, "");

    public Tree() {
        this('/');
    }

    public Tree(char separator) {
        this.separator = separator;
    }

    public void clear() {
        ((Node)this.root).elem = null;
        ((Node)this.root).children.clear();
    }

    public E put(String path, E elem) {
        Node<E> n = this.get(path, true);
        Object previous = ((Node)n).elem;
        ((Node)n).elem = elem;
        return (E)previous;
    }

    public E get(String path) {
        Node<E> n = this.get(path, false);
        return (E)(n == null ? null : ((Node)n).elem);
    }

    public Node<E> getNode(String path) {
        return this.get(path, false);
    }

    public E remove(String path) {
        Node<E> n = this.get(path, false);
        if (n == null) {
            return null;
        }
        Object previous = ((Node)n).elem;
        ((Node)n).elem = null;
        ((Node)n).prune();
        return (E)previous;
    }

    private Node<E> get(String path, boolean create) {
        String[] segs = Text.explode(path, this.separator);
        Node n = this.root;
        for (String name : segs) {
            Node c = n.get(name, create);
            if (c == null) {
                return null;
            }
            n = c;
        }
        return n;
    }

    public void removeChildren(String path) {
        Node<E> n = this.get(path, false);
        if (n != null) {
            ((Node)n).removeChildren();
        }
    }

    public Map<String, E> map() {
        LinkedHashMap map = new LinkedHashMap();
        this.fill(map, this.root, "");
        return map;
    }

    public String getRootPath() {
        Node n = this.root;
        StringBuffer path = new StringBuffer();
        while (n.elem == null && n.children.size() == 1) {
            n = (Node)n.children.values().iterator().next();
            path.append(this.separator).append(n.name);
        }
        if (path.length() == 0) {
            path.append(this.separator);
        }
        return path.toString();
    }

    public Node<E> getRootNode() {
        Node n = this.root;
        while (n.elem == null && n.children.size() == 1) {
            n = (Node)n.children.values().iterator().next();
        }
        return n;
    }

    private void fill(Map<String, E> map, Node<E> node, String parentPath) {
        String path = parentPath.length() != 1 ? parentPath + this.separator + ((Node)node).name : parentPath + ((Node)node).name;
        if (((Node)node).elem != null) {
            map.put(path, ((Node)node).elem);
        }
        for (Node child : ((Node)node).children.values()) {
            this.fill(map, child, path);
        }
    }

    public static class Node<E> {
        private String name;
        private E elem;
        private final Node parent;
        private final Map<String, Node<E>> children = new LinkedHashMap<String, Node<E>>();

        private Node(Node parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        private Node<E> get(String name, boolean create) {
            Node<E> child = this.children.get(name);
            if (child == null && create) {
                child = new Node<E>(this, name);
                this.children.put(name, child);
            }
            return child;
        }

        private Node<E> remove(String name) {
            return this.children.remove(name);
        }

        private void prune() {
            if (this.children.isEmpty() && this.elem == null && this.parent != null) {
                this.parent.remove(this.name);
                this.parent.prune();
            }
        }

        private void removeChildren() {
            this.children.clear();
            this.prune();
        }

        public String getName() {
            return this.name;
        }

        public E getElem() {
            return this.elem;
        }

        public Node getParent() {
            return this.parent;
        }

        public Map<String, Node<E>> getChildren() {
            return this.children;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Node");
            sb.append("{name='").append(this.name).append('\'');
            sb.append(", elem=").append(this.elem);
            sb.append(", children=").append(this.children.keySet());
            sb.append('}');
            return sb.toString();
        }
    }
}

