/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.mllib.optimization.NNLS;
import scala.math.package$;

public final class NNLS$ {
    public static NNLS$ MODULE$;

    static {
        new NNLS$();
    }

    public NNLS.Workspace createWorkspace(int n) {
        return new NNLS.Workspace(n);
    }

    public double[] solve(double[] ata, double[] atb, NNLS.Workspace ws) {
        ws.wipe();
        int n = atb.length;
        double[] scratch = ws.scratch();
        double[] grad = ws.grad();
        double[] x = ws.x();
        double[] dir = ws.dir();
        double[] lastDir = ws.lastDir();
        double[] res = ws.res();
        int iterMax = package$.MODULE$.max(400, 20 * n);
        double lastNorm = 0.0;
        int lastWall = 0;
        int i = 0;
        for (int iterno = 0; iterno < iterMax; ++iterno) {
            BLAS$.MODULE$.nativeBLAS().dgemv("N", n, n, 1.0, ata, n, x, 1, 0.0, res, 1);
            BLAS$.MODULE$.nativeBLAS().daxpy(n, -1.0, atb, 1, res, 1);
            BLAS$.MODULE$.nativeBLAS().dcopy(n, res, 1, grad, 1);
            for (i = 0; i < n; ++i) {
                if (!(grad[i] > 0.0) || x[i] != 0.0) continue;
                grad[i] = 0.0;
            }
            double ngrad = BLAS$.MODULE$.nativeBLAS().ddot(n, grad, 1, grad, 1);
            BLAS$.MODULE$.nativeBLAS().dcopy(n, grad, 1, dir, 1);
            double step = NNLS$.steplen$1(grad, res, n, ata, scratch);
            double ndir = 0.0;
            double nx = BLAS$.MODULE$.nativeBLAS().ddot(n, x, 1, x, 1);
            if (iterno > lastWall + 1) {
                double alpha = ngrad / lastNorm;
                BLAS$.MODULE$.nativeBLAS().daxpy(n, alpha, lastDir, 1, dir, 1);
                double dstep = NNLS$.steplen$1(dir, res, n, ata, scratch);
                ndir = BLAS$.MODULE$.nativeBLAS().ddot(n, dir, 1, dir, 1);
                if (NNLS$.stop$1(dstep, ndir, nx)) {
                    BLAS$.MODULE$.nativeBLAS().dcopy(n, grad, 1, dir, 1);
                    ndir = BLAS$.MODULE$.nativeBLAS().ddot(n, dir, 1, dir, 1);
                } else {
                    step = dstep;
                }
            } else {
                ndir = BLAS$.MODULE$.nativeBLAS().ddot(n, dir, 1, dir, 1);
            }
            if (NNLS$.stop$1(step, ndir, nx)) {
                return (double[])x.clone();
            }
            for (i = 0; i < n; ++i) {
                if (!(step * dir[i] > x[i])) continue;
                step = x[i] / dir[i];
            }
            for (i = 0; i < n; ++i) {
                if (step * dir[i] > x[i] * 0.99999999999999) {
                    x[i] = 0.0;
                    lastWall = iterno;
                    continue;
                }
                int n2 = i;
                x[n2] = x[n2] - step * dir[i];
            }
            BLAS$.MODULE$.nativeBLAS().dcopy(n, dir, 1, lastDir, 1);
            lastNorm = ngrad;
        }
        return (double[])x.clone();
    }

    private static final double steplen$1(double[] dir, double[] res, int n$1, double[] ata$1, double[] scratch$1) {
        double top = BLAS$.MODULE$.nativeBLAS().ddot(n$1, dir, 1, res, 1);
        BLAS$.MODULE$.nativeBLAS().dgemv("N", n$1, n$1, 1.0, ata$1, n$1, dir, 1, 0.0, scratch$1, 1);
        return top / (BLAS$.MODULE$.nativeBLAS().ddot(n$1, scratch$1, 1, dir, 1) + 1.0E-20);
    }

    private static final boolean stop$1(double step, double ndir, double nx) {
        return Double.isNaN(step) || step < 1.0E-7 || step > 1.0E40 || ndir < 1.0E-12 * nx || ndir < 1.0E-32;
    }

    private NNLS$() {
        MODULE$ = this;
    }
}

