/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class StringScalarConcatStringGroupCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;
    private byte[] value;

    public StringScalarConcatStringGroupCol(byte[] value, int colNum, int outputColumn) {
        this();
        this.colNum = colNum;
        this.outputColumn = outputColumn;
        this.value = value;
    }

    public StringScalarConcatStringGroupCol() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.colNum];
        BytesColumnVector outV = (BytesColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        byte[][] vector = inputColVector.vector;
        int[] start = inputColVector.start;
        int[] length = inputColVector.length;
        if (n == 0) {
            return;
        }
        outV.initBuffer();
        if (inputColVector.noNulls) {
            outV.noNulls = true;
            if (inputColVector.isRepeating) {
                outV.isRepeating = true;
                outV.setConcat(0, this.value, 0, this.value.length, vector[0], start[0], length[0]);
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outV.setConcat(i, this.value, 0, this.value.length, vector[i], start[i], length[i]);
                }
                outV.isRepeating = false;
            } else {
                for (int i = 0; i != n; ++i) {
                    outV.setConcat(i, this.value, 0, this.value.length, vector[i], start[i], length[i]);
                }
                outV.isRepeating = false;
            }
        } else {
            outV.noNulls = false;
            if (inputColVector.isRepeating) {
                outV.isRepeating = true;
                outV.isNull[0] = inputColVector.isNull[0];
                if (!inputColVector.isNull[0]) {
                    outV.setConcat(0, this.value, 0, this.value.length, vector[0], start[0], length[0]);
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!inputColVector.isNull[i]) {
                        outV.setConcat(i, this.value, 0, this.value.length, vector[i], start[i], length[i]);
                    }
                    outV.isNull[i] = inputColVector.isNull[i];
                }
                outV.isRepeating = false;
            } else {
                for (int i = 0; i != n; ++i) {
                    if (!inputColVector.isNull[i]) {
                        outV.setConcat(i, this.value, 0, this.value.length, vector[i], start[i], length[i]);
                    }
                    outV.isNull[i] = inputColVector.isNull[i];
                }
                outV.isRepeating = false;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "String_Family";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + StringScalarConcatStringGroupCol.displayUtf8Bytes(this.value) + ", col " + this.colNum;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

