/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Contains;
import org.apache.spark.sql.catalyst.expressions.EndsWith;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.Like;
import org.apache.spark.sql.catalyst.expressions.LikeAll;
import org.apache.spark.sql.catalyst.expressions.LikeAny;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MultiLikeBase;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.NotLikeAll;
import org.apache.spark.sql.catalyst.expressions.NotLikeAny;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.Or$;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.StartsWith;
import org.apache.spark.sql.catalyst.optimizer.CollapseProject$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.matching.Regex;

public final class LikeSimplification$
extends Rule<LogicalPlan>
implements PredicateHelper {
    public static LikeSimplification$ MODULE$;
    private final Regex startsWith;
    private final Regex endsWith;
    private final Regex startsAndEndsWith;
    private final Regex contains;
    private final Regex equalTo;

    static {
        new LikeSimplification$();
    }

    @Override
    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$(this, condition);
    }

    @Override
    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan2) {
        return PredicateHelper.findExpressionAndTrackLineageDown$(this, exp, plan2);
    }

    @Override
    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$(this, condition);
    }

    @Override
    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$(this, expressions, op);
    }

    @Override
    public boolean canEvaluate(Expression expr, LogicalPlan plan2) {
        return PredicateHelper.canEvaluate$(this, expr, plan2);
    }

    @Override
    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$(this, expr);
    }

    @Override
    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$(this, condition, outputSet);
    }

    @Override
    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$(this, expr);
    }

    @Override
    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$(this, output, nonNullAttrExprIds);
    }

    @Override
    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$(this, e);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Project plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Aggregate plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    @Override
    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$(this, expr, aliasMap);
    }

    @Override
    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$(this, expr, aliasMap);
    }

    @Override
    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$(this, e);
    }

    @Override
    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$(this, e);
    }

    private Regex startsWith() {
        return this.startsWith;
    }

    private Regex endsWith() {
        return this.endsWith;
    }

    private Regex startsAndEndsWith() {
        return this.startsAndEndsWith;
    }

    private Regex contains() {
        return this.contains;
    }

    private Regex equalTo() {
        return this.equalTo;
    }

    public Option<Expression> org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyLike(Expression input, String pattern, char escapeChar) {
        if (new StringOps(Predef$.MODULE$.augmentString(pattern)).contains((Object)BoxesRunTime.boxToCharacter((char)escapeChar))) {
            return None$.MODULE$;
        }
        String string = pattern;
        Option option = this.startsWith().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String prefix = (String)((LinearSeqOptimized)option.get()).apply(0);
            return new Some((Object)new StartsWith(input, Literal$.MODULE$.apply(prefix)));
        }
        Option option2 = this.endsWith().unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
            String postfix = (String)((LinearSeqOptimized)option2.get()).apply(0);
            return new Some((Object)new EndsWith(input, Literal$.MODULE$.apply(postfix)));
        }
        Option option3 = this.startsAndEndsWith().unapplySeq((CharSequence)string);
        if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
            String prefix = (String)((LinearSeqOptimized)option3.get()).apply(0);
            String postfix = (String)((LinearSeqOptimized)option3.get()).apply(1);
            return new Some((Object)new And(new GreaterThanOrEqual(new Length(input), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)(prefix.length() + postfix.length())))), new And(new StartsWith(input, Literal$.MODULE$.apply(prefix)), new EndsWith(input, Literal$.MODULE$.apply(postfix)))));
        }
        Option option4 = this.contains().unapplySeq((CharSequence)string);
        if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(1) == 0) {
            String infix = (String)((LinearSeqOptimized)option4.get()).apply(0);
            return new Some((Object)new Contains(input, Literal$.MODULE$.apply(infix)));
        }
        Option option5 = this.equalTo().unapplySeq((CharSequence)string);
        if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(1) == 0) {
            String str = (String)((LinearSeqOptimized)option5.get()).apply(0);
            return new Some((Object)new EqualTo(input, Literal$.MODULE$.apply(str)));
        }
        return None$.MODULE$;
    }

    private char simplifyLike$default$3() {
        return '\\';
    }

    public Expression org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyMultiLike(Expression child, Seq<UTF8String> patterns, MultiLikeBase multi) {
        Tuple2 tuple2 = ((TraversableLike)patterns.map((Function1 & Serializable & scala.Serializable)p2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p2), (Object)Option$.MODULE$.apply(p2).flatMap((Function1 & Serializable & scala.Serializable)p -> MODULE$.org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyLike(child, p.toString(), MODULE$.simplifyLike$default$3()))), Seq$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)LikeSimplification$.$anonfun$simplifyMultiLike$3(x$37)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq remainPatternMap = (Seq)tuple2._1();
        Seq replacementMap = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)remainPatternMap, (Object)replacementMap);
        Seq remainPatternMap2 = (Seq)tuple22._1();
        Seq replacementMap2 = (Seq)tuple22._2();
        Seq remainPatterns = (Seq)remainPatternMap2.map((Function1 & Serializable & scala.Serializable)x$39 -> (UTF8String)x$39._1(), Seq$.MODULE$.canBuildFrom());
        Seq replacements = (Seq)replacementMap2.map((Function1 & Serializable & scala.Serializable)x$40 -> (Expression)((Option)x$40._2()).get(), Seq$.MODULE$.canBuildFrom());
        if (replacements.isEmpty()) {
            return multi;
        }
        MultiLikeBase multiLikeBase = multi;
        if (multiLikeBase instanceof LikeAll) {
            LikeAll likeAll = (LikeAll)multiLikeBase;
            Expression and = this.buildBalancedPredicate((Seq<Expression>)replacements, (Function2<Expression, Expression, Expression>)And$.MODULE$);
            if (remainPatterns.nonEmpty()) {
                Seq x$1 = remainPatterns;
                Expression x$2 = likeAll.copy$default$1();
                return new And(and, likeAll.copy(x$2, (Seq<UTF8String>)x$1));
            }
            return and;
        }
        if (multiLikeBase instanceof NotLikeAll) {
            NotLikeAll notLikeAll = (NotLikeAll)multiLikeBase;
            Expression and = this.buildBalancedPredicate((Seq<Expression>)((Seq)replacements.map((Function1 & Serializable & scala.Serializable)x$41 -> new Not((Expression)x$41), Seq$.MODULE$.canBuildFrom())), (Function2<Expression, Expression, Expression>)And$.MODULE$);
            if (remainPatterns.nonEmpty()) {
                Seq x$3 = remainPatterns;
                Expression x$4 = notLikeAll.copy$default$1();
                return new And(and, notLikeAll.copy(x$4, (Seq<UTF8String>)x$3));
            }
            return and;
        }
        if (multiLikeBase instanceof LikeAny) {
            LikeAny likeAny = (LikeAny)multiLikeBase;
            Expression or = this.buildBalancedPredicate((Seq<Expression>)replacements, (Function2<Expression, Expression, Expression>)Or$.MODULE$);
            if (remainPatterns.nonEmpty()) {
                Seq x$5 = remainPatterns;
                Expression x$6 = likeAny.copy$default$1();
                return new Or(or, likeAny.copy(x$6, (Seq<UTF8String>)x$5));
            }
            return or;
        }
        if (multiLikeBase instanceof NotLikeAny) {
            NotLikeAny notLikeAny = (NotLikeAny)multiLikeBase;
            Expression or = this.buildBalancedPredicate((Seq<Expression>)((Seq)replacements.map((Function1 & Serializable & scala.Serializable)x$42 -> new Not((Expression)x$42), Seq$.MODULE$.canBuildFrom())), (Function2<Expression, Expression, Expression>)Or$.MODULE$);
            if (remainPatterns.nonEmpty()) {
                Seq x$7 = remainPatterns;
                Expression x$8 = notLikeAny.copy$default$1();
                return new Or(or, notLikeAny.copy(x$8, (Seq<UTF8String>)x$7));
            }
            return or;
        }
        throw new MatchError((Object)multiLikeBase);
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return plan2.transformAllExpressionsWithPruning((Function1 & Serializable & scala.Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)x$43.containsPattern(TreePattern$.MODULE$.LIKE_FAMLIY())), this.ruleId(), (PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Like) {
                    Like like = (Like)A1;
                    Expression input = like.left();
                    Expression expression = like.right();
                    char escapeChar = like.escapeChar();
                    if (expression instanceof Literal) {
                        Literal literal = (Literal)expression;
                        Object pattern = literal.value();
                        DataType dataType = literal.dataType();
                        if (StringType$.MODULE$.equals(dataType)) {
                            if (pattern == null) {
                                return (B1)new Literal(null, (DataType)BooleanType$.MODULE$);
                            }
                            return (B1)LikeSimplification$.MODULE$.org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyLike(input, pattern.toString(), escapeChar).getOrElse((Function0 & Serializable & scala.Serializable)() -> like);
                        }
                    }
                }
                if (A1 instanceof LikeAll) {
                    LikeAll likeAll = (LikeAll)A1;
                    Expression child = likeAll.child();
                    Seq<UTF8String> patterns = likeAll.patterns();
                    if (CollapseProject$.MODULE$.isCheap(child)) {
                        return (B1)LikeSimplification$.MODULE$.org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyMultiLike(child, patterns, likeAll);
                    }
                }
                if (A1 instanceof NotLikeAll) {
                    NotLikeAll notLikeAll = (NotLikeAll)A1;
                    Expression child = notLikeAll.child();
                    Seq<UTF8String> patterns = notLikeAll.patterns();
                    if (CollapseProject$.MODULE$.isCheap(child)) {
                        return (B1)LikeSimplification$.MODULE$.org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyMultiLike(child, patterns, notLikeAll);
                    }
                }
                if (A1 instanceof LikeAny) {
                    LikeAny likeAny = (LikeAny)A1;
                    Expression child = likeAny.child();
                    Seq<UTF8String> patterns = likeAny.patterns();
                    if (CollapseProject$.MODULE$.isCheap(child)) {
                        return (B1)LikeSimplification$.MODULE$.org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyMultiLike(child, patterns, likeAny);
                    }
                }
                if (A1 instanceof NotLikeAny) {
                    NotLikeAny notLikeAny = (NotLikeAny)A1;
                    Expression child = notLikeAny.child();
                    Seq<UTF8String> patterns = notLikeAny.patterns();
                    if (CollapseProject$.MODULE$.isCheap(child)) {
                        return (B1)LikeSimplification$.MODULE$.org$apache$spark$sql$catalyst$optimizer$LikeSimplification$$simplifyMultiLike(child, patterns, notLikeAny);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                NotLikeAny notLikeAny;
                Expression child;
                LikeAny likeAny;
                Expression child2;
                NotLikeAll notLikeAll;
                Expression child3;
                LikeAll likeAll;
                Expression child4;
                Literal literal;
                DataType dataType;
                Like like;
                Expression expression;
                Expression expression2 = x1;
                if (expression2 instanceof Like && (expression = (like = (Like)expression2).right()) instanceof Literal && StringType$.MODULE$.equals(dataType = (literal = (Literal)expression).dataType())) {
                    return true;
                }
                if (expression2 instanceof LikeAll && CollapseProject$.MODULE$.isCheap(child4 = (likeAll = (LikeAll)expression2).child())) {
                    return true;
                }
                if (expression2 instanceof NotLikeAll && CollapseProject$.MODULE$.isCheap(child3 = (notLikeAll = (NotLikeAll)expression2).child())) {
                    return true;
                }
                if (expression2 instanceof LikeAny && CollapseProject$.MODULE$.isCheap(child2 = (likeAny = (LikeAny)expression2).child())) {
                    return true;
                }
                return expression2 instanceof NotLikeAny && CollapseProject$.MODULE$.isCheap(child = (notLikeAny = (NotLikeAny)expression2).child());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$59(org.apache.spark.sql.catalyst.expressions.Like )}, serializedLambda);
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$simplifyMultiLike$3(Tuple2 x$37) {
        return ((Option)x$37._2()).isEmpty();
    }

    private LikeSimplification$() {
        MODULE$ = this;
        AliasHelper.$init$(this);
        PredicateHelper.$init$(this);
        this.startsWith = new StringOps(Predef$.MODULE$.augmentString("([^_%]+)%")).r();
        this.endsWith = new StringOps(Predef$.MODULE$.augmentString("%([^_%]+)")).r();
        this.startsAndEndsWith = new StringOps(Predef$.MODULE$.augmentString("([^_%]+)%([^_%]+)")).r();
        this.contains = new StringOps(Predef$.MODULE$.augmentString("%([^_%]+)%")).r();
        this.equalTo = new StringOps(Predef$.MODULE$.augmentString("([^_%]*)")).r();
    }
}

