/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringLocate$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(substr, str[, pos]) - Returns the position of the first occurrence of `substr` in `str` after position `pos`.\n      The given `pos` and return value are 1-based.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('bar', 'foobarbar');\n       4\n      > SELECT _FUNC_('bar', 'foobarbar', 5);\n       7\n      > SELECT POSITION('bar' IN 'foobarbar');\n       4\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\tea\u0001B\u0013'\u0001NB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011!)\u0006A!f\u0001\n\u0003q\u0005\u0002\u0003,\u0001\u0005#\u0005\u000b\u0011B(\t\u000b]\u0003A\u0011\u0001-\t\u000b]\u0003A\u0011A/\t\u000b\u0001\u0004A\u0011\t(\t\u000b\u0005\u0004A\u0011\t(\t\u000b\t\u0004A\u0011\t(\t\u000b\r\u0004A\u0011\t3\t\u000b!\u0004A\u0011I5\t\u000bA\u0004A\u0011I9\t\u000bU\u0004A\u0011\t<\t\u000f\u0005\u0005\u0001\u0001\"\u0015\u0002\u0004!9\u0011q\u0004\u0001\u0005B\u0005\u0005\u0002bBA\u001a\u0001\u0011E\u0013Q\u0007\u0005\n\u0003\u0007\u0002\u0011\u0011!C\u0001\u0003\u000bB\u0011\"!\u0014\u0001#\u0003%\t!a\u0014\t\u0013\u0005\u0015\u0004!%A\u0005\u0002\u0005=\u0003\"CA4\u0001E\u0005I\u0011AA(\u0011%\tI\u0007AA\u0001\n\u0003\nY\u0007C\u0005\u0002|\u0001\t\t\u0011\"\u0001\u0002~!I\u0011Q\u0011\u0001\u0002\u0002\u0013\u0005\u0011q\u0011\u0005\n\u0003\u001b\u0003\u0011\u0011!C!\u0003\u001fC\u0011\"!(\u0001\u0003\u0003%\t!a(\t\u0013\u0005\r\u0006!!A\u0005B\u0005\u0015\u0006\"CAU\u0001\u0005\u0005I\u0011IAV\u000f%\tyMJA\u0001\u0012\u0003\t\tN\u0002\u0005&M\u0005\u0005\t\u0012AAj\u0011\u00199v\u0004\"\u0001\u0002l\"I\u0011Q^\u0010\u0002\u0002\u0013\u0015\u0013q\u001e\u0005\n\u0003c|\u0012\u0011!CA\u0003gD\u0011\"a? \u0003\u0003%\t)!@\t\u0013\t=q$!A\u0005\n\tE!\u0001D*ue&tw\rT8dCR,'BA\u0014)\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005%R\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005-b\u0013aA:rY*\u0011QFL\u0001\u0006gB\f'o\u001b\u0006\u0003_A\na!\u00199bG\",'\"A\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001!\u0004hO!\u0011\u0005U2T\"\u0001\u0014\n\u0005]2#!\u0005+fe:\f'/_#yaJ,7o]5p]B\u0011Q'O\u0005\u0003u\u0019\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\b!J|G-^2u!\t\u0011%J\u0004\u0002D\u0011:\u0011AiR\u0007\u0002\u000b*\u0011aIM\u0001\u0007yI|w\u000e\u001e \n\u0003yJ!!S\u001f\u0002\u000fA\f7m[1hK&\u00111\n\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0013v\naa];cgR\u0014X#A(\u0011\u0005U\u0002\u0016BA)'\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\bgV\u00147\u000f\u001e:!\u0003\r\u0019HO]\u0001\u0005gR\u0014\b%A\u0003ti\u0006\u0014H/\u0001\u0004ti\u0006\u0014H\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\teS6\f\u0018\t\u0003k\u0001AQ!T\u0004A\u0002=CQaU\u0004A\u0002=CQ!V\u0004A\u0002=#2!\u00170`\u0011\u0015i\u0005\u00021\u0001P\u0011\u0015\u0019\u0006\u00021\u0001P\u0003\u00151\u0017N]:u\u0003\u0019\u0019XmY8oI\u0006)A\u000f[5sI\u0006Aa.\u001e7mC\ndW-F\u0001f!\tad-\u0003\u0002h{\t9!i\\8mK\u0006t\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003)\u0004\"a\u001b8\u000e\u00031T!!\u001c\u0016\u0002\u000bQL\b/Z:\n\u0005=d'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001s!\r\u00115O[\u0005\u0003i2\u00131aU3r\u0003\u0011)g/\u00197\u0015\u0005]T\bC\u0001\u001fy\u0013\tIXHA\u0002B]fDqa_\b\u0011\u0002\u0003\u0007A0A\u0003j]B,H\u000f\u0005\u0002~}6\t\u0001&\u0003\u0002\u0000Q\tY\u0011J\u001c;fe:\fGNU8x\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\u0006\u0005E\u00111\u0004\t\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111\u0002\u0014\u0002\u000f\r|G-Z4f]&!\u0011qBA\u0005\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\n!\u0001\u0007\u0011QC\u0001\u0004GRD\b\u0003BA\u0004\u0003/IA!!\u0007\u0002\n\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA\u000f!\u0001\u0007\u0011QA\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\t\t\u0019\u0003\u0005\u0003\u0002&\u00055b\u0002BA\u0014\u0003S\u0001\"\u0001R\u001f\n\u0007\u0005-R(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\t\tD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Wi\u0014aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u001dI\u0016qGA\u001e\u0003\u007fAa!!\u000f\u0013\u0001\u0004y\u0015\u0001\u00038fo\u001aK'o\u001d;\t\r\u0005u\"\u00031\u0001P\u0003%qWm^*fG>tG\r\u0003\u0004\u0002BI\u0001\raT\u0001\t]\u0016<H\u000b[5sI\u0006!1m\u001c9z)\u001dI\u0016qIA%\u0003\u0017Bq!T\n\u0011\u0002\u0003\u0007q\nC\u0004T'A\u0005\t\u0019A(\t\u000fU\u001b\u0002\u0013!a\u0001\u001f\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA)U\ry\u00151K\u0016\u0003\u0003+\u0002B!a\u0016\u0002b5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&A\u0005v]\u000eDWmY6fI*\u0019\u0011qL\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002d\u0005e#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u00055\u0004\u0003BA8\u0003sj!!!\u001d\u000b\t\u0005M\u0014QO\u0001\u0005Y\u0006twM\u0003\u0002\u0002x\u0005!!.\u0019<b\u0013\u0011\ty#!\u001d\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005}\u0004c\u0001\u001f\u0002\u0002&\u0019\u00111Q\u001f\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007]\fI\tC\u0005\u0002\ff\t\t\u00111\u0001\u0002\u0000\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!%\u0011\u000b\u0005M\u0015\u0011T<\u000e\u0005\u0005U%bAAL{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0015Q\u0013\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002f\u0003CC\u0001\"a#\u001c\u0003\u0003\u0005\ra^\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002n\u0005\u001d\u0006\"CAF9\u0005\u0005\t\u0019AA@\u0003\u0019)\u0017/^1mgR\u0019Q-!,\t\u0011\u0005-U$!AA\u0002]D3\u0003AAY\u0003o\u000bI,!0\u0002@\u0006\r\u0017QYAe\u0003\u0017\u00042!NAZ\u0013\r\t)L\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tY,AA1\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:vEN$(\u000f\f\u0011tiJ\\F\u0006\t9pgvK\u0003%\f\u0011SKR,(O\\:!i\",\u0007\u0005]8tSRLwN\u001c\u0011pM\u0002\"\b.\u001a\u0011gSJ\u001cH\u000fI8dGV\u0014(/\u001a8dK\u0002zg\r\t1tk\n\u001cHO\u001d1!S:\u0004\u0003m\u001d;sA\u0002\ng\r^3sAA|7/\u001b;j_:\u0004\u0003\r]8tA:R\u0001\u0005\t\u0011!A\u0001\"\u0006.\u001a\u0011hSZ,g\u000e\t1q_N\u0004\u0007%\u00198eAI,G/\u001e:oAY\fG.^3!CJ,\u0007%M\u0017cCN,GM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002B\u0006\tIG\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(E\u0006\u0014x\u0005\f\u0011(M>|'-\u0019:cCJ<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00115\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#-\u0019:(Y\u0001:cm\\8cCJ\u0014\u0017M]\u0014-AUJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001c\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAA{5+\u0013+J\u001f:CsEY1sO\u0001Je\nI\u0014g_>\u0014\u0017M\u001d2be\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001b\u000bA\u0001\nQa]5oG\u0016\f#!a2\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u00055\u0017\u0001D:ue&twm\u00184v]\u000e\u001c\u0018\u0001D*ue&tw\rT8dCR,\u0007CA\u001b '\u0015y\u0012Q[Aq!!\t9.!8P\u001f>KVBAAm\u0015\r\tY.P\u0001\beVtG/[7f\u0013\u0011\ty.!7\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0002d\u0006%XBAAs\u0015\u0011\t9/!\u001e\u0002\u0005%|\u0017bA&\u0002fR\u0011\u0011\u0011[\u0001\ti>\u001cFO]5oOR\u0011\u0011QN\u0001\u0006CB\u0004H.\u001f\u000b\b3\u0006U\u0018q_A}\u0011\u0015i%\u00051\u0001P\u0011\u0015\u0019&\u00051\u0001P\u0011\u0015)&\u00051\u0001P\u0003\u001d)h.\u00199qYf$B!a@\u0003\fA)AH!\u0001\u0003\u0006%\u0019!1A\u001f\u0003\r=\u0003H/[8o!\u0019a$qA(P\u001f&\u0019!\u0011B\u001f\u0003\rQ+\b\u000f\\34\u0011!\u0011iaIA\u0001\u0002\u0004I\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!1\u0003\t\u0005\u0003_\u0012)\"\u0003\u0003\u0003\u0018\u0005E$AB(cU\u0016\u001cG\u000f")
public class StringLocate
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression substr;
    private final Expression str;
    private final Expression start;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringLocate x$0) {
        return StringLocate$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringLocate> tupled() {
        return StringLocate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringLocate>>> curried() {
        return StringLocate$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression substr() {
        return this.substr;
    }

    public Expression str() {
        return this.str;
    }

    public Expression start() {
        return this.start;
    }

    @Override
    public Expression first() {
        return this.substr();
    }

    @Override
    public Expression second() {
        return this.str();
    }

    @Override
    public Expression third() {
        return this.start();
    }

    @Override
    public boolean nullable() {
        return this.substr().nullable() || this.str().nullable();
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Object eval(InternalRow input) {
        int sVal;
        Object l;
        Object r;
        Object s = this.start().eval(input);
        return s == null ? BoxesRunTime.boxToInteger((int)0) : ((r = this.substr().eval(input)) == null ? null : ((l = this.str().eval(input)) == null ? null : ((sVal = BoxesRunTime.unboxToInt((Object)s)) < 1 ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)(((UTF8String)l).indexOf((UTF8String)r, BoxesRunTime.unboxToInt((Object)s) - 1) + 1)))));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode substrGen = this.substr().genCode(ctx);
        ExprCode strGen = this.str().genCode(ctx);
        ExprCode startGen = this.start().genCode(ctx);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      int ", " = 0;\n      boolean ", " = false;\n      ", "\n      if (!", ") {\n        ", "\n        if (!", ") {\n          ", "\n          if (!", ") {\n            if (", " > 0) {\n              ", " = ", ".indexOf(", ",\n                ", " - 1) + 1;\n            }\n          } else {\n            ", " = true;\n          }\n        } else {\n          ", " = true;\n        }\n      }\n     "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), ev.isNull(), startGen.code(), startGen.isNull(), substrGen.code(), substrGen.isNull(), strGen.code(), strGen.isNull(), startGen.value(), ev.value(), strGen.value(), substrGen.value(), startGen.value(), ev.isNull(), ev.isNull()})), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "locate");
    }

    @Override
    public StringLocate withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringLocate copy(Expression substr, Expression str, Expression start) {
        return new StringLocate(substr, str, start);
    }

    public Expression copy$default$1() {
        return this.substr();
    }

    public Expression copy$default$2() {
        return this.str();
    }

    public Expression copy$default$3() {
        return this.start();
    }

    @Override
    public String productPrefix() {
        return "StringLocate";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.substr();
                break;
            }
            case 1: {
                object = this.str();
                break;
            }
            case 2: {
                object = this.start();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringLocate;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "substr";
                break;
            }
            case 1: {
                string = "str";
                break;
            }
            case 2: {
                string = "start";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringLocate)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringLocate stringLocate = (StringLocate)x$1;
        Expression expression = this.substr();
        Expression expression2 = stringLocate.substr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.str();
        Expression expression4 = stringLocate.str();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.start();
        Expression expression6 = stringLocate.start();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringLocate.canEqual(this)) return false;
        return true;
    }

    public StringLocate(Expression substr, Expression str, Expression start) {
        this.substr = substr;
        this.str = str;
        this.start = start;
        ExpectsInputTypes.$init$(this);
    }

    public StringLocate(Expression substr, Expression str) {
        this(substr, str, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

